/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.OneToOneActionParameter;
import org.nakedobjects.metamodel.spec.feature.ParseableEntryActionParameter;
import org.nakedobjects.plugins.dndviewer.ParameterContent;
import org.nakedobjects.plugins.dndviewer.viewer.content.ObjectParameterImpl;
import org.nakedobjects.plugins.dndviewer.viewer.content.TextParseableParameterImpl;

public class ActionHelper {
    private final NakedObjectAction action;
    private final NakedObject[] parameters;
    private final NakedObject target;
    private final NakedObject[][] options;

    public static ActionHelper createInstance(NakedObject target, NakedObjectAction action) {
        int i;
        int numberParameters = action.getParameterCount();
        NakedObject[] parameters = new NakedObject[numberParameters];
        NakedObjectActionParameter[] parameterSpecs = action.getParameters();
        NakedObject[] defaultValues = new NakedObject[parameterSpecs.length];
        NakedObject[][] options = new NakedObject[parameterSpecs.length][];
        for (i = 0; i < parameterSpecs.length; ++i) {
            defaultValues[i] = parameterSpecs[i].getDefault(target);
            options[i] = parameterSpecs[i].getChoices(target);
        }
        if (!ActionHelper.hasValues(defaultValues) && !ActionHelper.hasValues(options)) {
            defaultValues = action.getDefaults(target);
            options = action.getChoices(target);
        }
        for (i = 0; i < parameterSpecs.length; ++i) {
            parameters[i] = defaultValues[i] != null ? defaultValues[i] : null;
        }
        return new ActionHelper(target, action, parameters, defaultValues, options);
    }

    private ActionHelper(NakedObject target, NakedObjectAction action, NakedObject[] parameters, NakedObject[] defaultValues, NakedObject[][] options) {
        this.target = target;
        this.action = action;
        this.parameters = parameters;
        this.options = options;
    }

    public ParameterContent[] createParameters() {
        ParameterContent[] parameterContents = new ParameterContent[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            NakedObjectActionParameter[] parameters2 = this.action.getParameters();
            NakedObject nakedObject = this.parameters[i];
            NakedObjectSpecification specification = parameters2[i].getSpecification();
            if (specification.isParseable()) {
                ParseableEntryActionParameter parseableEntryActionParameter = (ParseableEntryActionParameter)parameters2[i];
                parameterContents[i] = new TextParseableParameterImpl(parseableEntryActionParameter, nakedObject, this.options[i], i, this);
                continue;
            }
            parameterContents[i] = new ObjectParameterImpl((OneToOneActionParameter)parameters2[i], nakedObject, this.options[i], i, this);
        }
        return parameterContents;
    }

    public Consent disabled() {
        return this.action.isProposedArgumentSetValid(this.target, this.parameters);
    }

    public String getName() {
        return this.action.getName();
    }

    public String getDescription() {
        return this.action.getDescription();
    }

    public String getHelp() {
        return this.action.getHelp();
    }

    public NakedObject getParameter(int index) {
        return this.parameters[index];
    }

    public NakedObject getTarget() {
        return this.action.realTarget(this.target);
    }

    public NakedObject invoke() {
        return this.action.execute(this.target, this.parameters);
    }

    public void setParameter(int index, NakedObject parameter) {
        this.parameters[index] = parameter;
    }

    public String title() {
        return this.getTarget().titleString();
    }

    public String getIconName() {
        return this.getTarget().getIconName();
    }

    private static boolean hasValues(NakedObject[] values) {
        if (values != null) {
            for (NakedObject nakedObject : values) {
                if (nakedObject == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasValues(NakedObject[][] values) {
        if (values != null) {
            for (NakedObject[] nakedObjectArray : values) {
                if (!ActionHelper.hasValues(nakedObjectArray)) continue;
                return true;
            }
        }
        return false;
    }
}

