/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.NakedObjectList;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.viewer.action.DisposeObjectOption;
import org.nakedobjects.plugins.dndviewer.viewer.content.DialoggedObjectOption;
import org.nakedobjects.plugins.dndviewer.viewer.content.ImmediateObjectOption;

public class OptionFactory {
    public static void addCreateOptions(NakedObjectSpecification specification, UserActionSet options) {
        NakedObjectAction[] actions = specification.getServiceActionsFor(NakedObjectActionConstants.USER);
        OptionFactory.menuOptions(actions, null, options);
    }

    public static void addObjectMenuOptions(NakedObject object, UserActionSet options) {
        if (object != null) {
            boolean isPersistent;
            NakedObjectAction[] actions1 = object.getSpecification().getObjectActions(NakedObjectActionConstants.USER);
            NakedObjectAction[] actions2 = object.getSpecification().getObjectActions(NakedObjectActionConstants.EXPLORATION);
            NakedObjectAction[] actions3 = object.getSpecification().getObjectActions(NakedObjectActionConstants.DEBUG);
            NakedObjectAction[] actions = (NakedObjectAction[])ArrayUtils.combine((Object[][])new NakedObjectAction[][]{actions1, actions2, actions3});
            OptionFactory.menuOptions(actions, object, options);
            Oid oid = object.getOid();
            boolean bl = isPersistent = oid != null && !oid.isTransient();
            if (!object.getSpecification().isService() && !(object.getObject() instanceof NakedObjectList) && isPersistent) {
                options.add(new DisposeObjectOption());
            }
        }
    }

    private static void menuOptions(NakedObjectAction[] actions, NakedObject target, UserActionSet menuOptionSet) {
        for (int i = 0; i < actions.length; ++i) {
            UserAction option = null;
            if (actions[i].getActions().length > 0) {
                option = new UserActionSet(actions[i].getName(), menuOptionSet);
                OptionFactory.menuOptions(actions[i].getActions(), target, option);
            } else {
                int noOfParameters = actions[i].getParameterCount();
                option = noOfParameters == 0 ? ImmediateObjectOption.createOption(actions[i], target) : (actions[i].isContributed() && noOfParameters == 1 && target != null && target.getSpecification().isOfType(actions[i].getParameters()[0].getSpecification()) ? ImmediateObjectOption.createServiceOption(actions[i], target) : DialoggedObjectOption.createOption(actions[i], target));
            }
            if (option == null) continue;
            menuOptionSet.add(option);
        }
    }
}

