/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.debug;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Shape;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;

public class DebugCanvas
implements Canvas {
    private final DebugString buffer;
    private final int level;

    public DebugCanvas(DebugString buffer, Bounds bounds) {
        this(buffer, 0);
    }

    private DebugCanvas(DebugString buffer, int level) {
        this.level = level;
        this.buffer = buffer;
    }

    public void clearBackground(View view, Color color) {
        this.indent();
        this.buffer.appendln("Clear background of " + view + " to " + color);
    }

    public Canvas createSubcanvas() {
        this.buffer.blankLine();
        this.indent();
        this.buffer.appendln("Create subcanvas for same area");
        return new DebugCanvas(this.buffer, this.level + 1);
    }

    public Canvas createSubcanvas(Bounds bounds) {
        return this.createSubcanvas(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public Canvas createSubcanvas(int x, int y, int width, int height) {
        this.buffer.blankLine();
        this.indent();
        this.buffer.appendln("Create subcanvas for area " + x + "," + y + " " + width + "x" + height);
        return new DebugCanvas(this.buffer, this.level + 1);
    }

    public void draw3DRectangle(int x, int y, int width, int height, Color color, boolean raised) {
        this.indent();
        this.buffer.appendln("Rectangle (3D) " + x + "," + y + " " + width + "x" + height);
    }

    public void drawImage(Image image, int x, int y) {
        this.indent();
        this.buffer.appendln("Icon " + x + "," + y + " " + image.getWidth() + "x" + image.getHeight());
    }

    public void drawImage(Image image, int x, int y, int width, int height) {
        this.indent();
        this.buffer.appendln("Icon " + x + "," + y + " " + width + "x" + height);
    }

    public void drawLine(int x, int y, int x2, int y2, Color color) {
        this.indent();
        this.buffer.appendln("Line from " + x + "," + y + " to " + x2 + "," + y2 + " " + color);
    }

    public void drawLine(Location start, int xExtent, int yExtent, Color color) {
        this.indent();
        this.buffer.appendln("Line from " + start.getX() + "," + start.getY() + " to " + (start.getX() + xExtent) + "," + (start.getY() + yExtent) + " " + color);
    }

    public void drawOval(int x, int y, int width, int height, Color color) {
        this.indent();
        this.buffer.appendln("Oval " + x + "," + y + " " + width + "x" + height + " " + color);
    }

    public void drawRectangle(int x, int y, int width, int height, Color color) {
        this.indent();
        this.buffer.appendln("Rectangle " + x + "," + y + " " + width + "x" + height + " " + color);
    }

    public void drawRectangleAround(View view, Color color) {
        Bounds bounds = view.getBounds();
        this.indent();
        this.buffer.appendln("Rectangle 0,0 " + bounds.getWidth() + "x" + bounds.getHeight() + " " + color);
    }

    public void drawRoundedRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, Color color) {
        this.indent();
        this.buffer.appendln("Rounded Rectangle " + x + "," + y + " " + (x + width) + "x" + (y + height) + " " + color);
    }

    public void drawShape(Shape shape, Color color) {
        this.indent();
        this.buffer.appendln("Shape " + shape + " " + color);
    }

    public void drawShape(Shape shape, int x, int y, Color color) {
        this.indent();
        this.buffer.appendln("Shape " + shape + " at " + x + "/" + y + " (left, top)" + " " + color);
    }

    public void drawSolidOval(int x, int y, int width, int height, Color color) {
        this.indent();
        this.buffer.appendln("Oval (solid) " + x + "," + y + " " + width + "x" + height + " " + color);
    }

    public void drawSolidRectangle(int x, int y, int width, int height, Color color) {
        this.indent();
        this.buffer.appendln("Rectangle (solid) " + x + "," + y + " " + width + "x" + height + " " + color);
    }

    public void drawSolidShape(Shape shape, Color color) {
        this.indent();
        this.buffer.appendln("Shape (solid) " + shape + " " + color);
    }

    public void drawSolidShape(Shape shape, int x, int y, Color color) {
        this.indent();
        this.buffer.appendln("Shape (solid)" + shape + " at " + x + "/" + y + " (left, top)" + " " + color);
    }

    public void drawText(String text, int x, int y, Color color, Text style) {
        this.indent();
        this.buffer.appendln("Text " + x + "," + y + " \"" + text + "\" " + style + " " + color);
    }

    public void drawText(String text, int x, int y, int maxWidth, Color color, Text style) {
        this.indent();
        this.buffer.appendln("Text " + x + "," + y + " +" + maxWidth + "xh \"" + text + "\" " + style + " " + color);
    }

    private void indent() {
        for (int i = 0; i < this.level; ++i) {
            this.buffer.append((Object)"   ");
        }
    }

    public void offset(int x, int y) {
        this.indent();
        this.buffer.appendln("Offset by " + x + "/" + y + " (left, top)");
    }

    public boolean overlaps(Bounds bounds) {
        return true;
    }

    public String toString() {
        return "Canvas";
    }

    public void drawDebugOutline(Bounds bounds, int baseline, Color color) {
    }
}

