/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.drawing;

import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;

public class Offset {
    private int dx;
    private int dy;

    public Offset(Location locationInViewer, Location locationInView) {
        this.dx = locationInViewer.getX() - locationInView.getX();
        this.dy = locationInViewer.getY() - locationInView.getY();
    }

    public Offset(int dx, int dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public Offset(Location location) {
        this.dx = location.getX();
        this.dy = location.getY();
    }

    public int getDeltaX() {
        return this.dx;
    }

    public int getDeltaY() {
        return this.dy;
    }

    public Location offset(Location locationInViewer) {
        Location location = new Location(locationInViewer);
        location.move(this.dx, this.dy);
        return location;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Offset) {
            Offset offset = (Offset)obj;
            return offset.dx == this.dx && offset.dy == this.dy;
        }
        return false;
    }

    public String toString() {
        return "Offset " + this.dx + ", " + this.dy;
    }

    public void add(int dx, int dy) {
        this.dx += dx;
        this.dy += dy;
    }

    public void subtract(int dx, int dy) {
        this.add(-dx, -dy);
    }
}

