/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.drawing;

import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;

public class Size {
    public static final Size ALL = new Size(2000, 20000);
    int height;
    int width;

    public Size() {
        this.width = 0;
        this.height = 0;
    }

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size(Size size) {
        this.width = size.width;
        this.height = size.height;
    }

    public void contract(int width, int height) {
        this.width -= width;
        this.height -= height;
    }

    public void contract(Size size) {
        this.width -= size.width;
        this.height -= size.height;
    }

    public void contractHeight(int height) {
        this.height -= height;
    }

    public void contract(Padding padding) {
        this.height -= padding.top + padding.bottom;
        this.width -= padding.left + padding.right;
    }

    public void contractWidth(int width) {
        this.width -= width;
    }

    public void ensureHeight(int height) {
        this.height = Math.max(this.height, height);
    }

    public void ensureWidth(int width) {
        this.width = Math.max(this.width, width);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Size) {
            Size object = (Size)obj;
            return object.width == this.width && object.height == this.height;
        }
        return false;
    }

    public void extend(int width, int height) {
        this.width += width;
        this.height += height;
    }

    public void extend(Padding padding) {
        this.width += padding.getLeftRight();
        this.height += padding.getTopBottom();
    }

    public void extend(Size size) {
        this.width += size.width;
        this.height += size.height;
    }

    public void extendHeight(int height) {
        this.height += height;
    }

    public void extendWidth(int width) {
        this.width += width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void limitHeight(int maximum) {
        this.height = Math.min(this.height, maximum);
    }

    public void limitWidth(int maximum) {
        this.width = Math.min(this.width, maximum);
    }

    public void limitSize(Size maximum) {
        this.limitWidth(maximum.width);
        this.limitHeight(maximum.height);
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String toString() {
        return this.width + "x" + this.height;
    }
}

