/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.list;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.OneToManyField;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.list.InternalCollectionIconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;

public class InternalCollectionBorder
extends AbstractBorder {
    private final IconGraphic icon = new InternalCollectionIconGraphic((View)this, Toolkit.getText("text.normal"));

    protected InternalCollectionBorder(View wrappedView) {
        super(wrappedView);
        this.left = this.icon.getSize().getWidth();
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)"InternalCollectionBorder ");
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(this.left + 45 + this.right);
        size.ensureHeight(24);
        return size;
    }

    public void draw(Canvas canvas) {
        this.icon.draw(canvas, 0, this.getBaseline());
        NakedObject collection = this.getContent().getNaked();
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        if (collection == null || facet.size(collection) == 0) {
            canvas.drawText("empty", this.left, this.getBaseline(), Toolkit.getColor("color.secondary2"), Toolkit.getText("text.normal"));
        } else {
            int x = this.icon.getSize().getWidth() / 2;
            int x2 = x + 4;
            int y = this.icon.getSize().getHeight() + 1;
            int y2 = this.getSize().getHeight() - 5;
            canvas.drawLine(x, y, x, y2, Toolkit.getColor("color.secondary2"));
            canvas.drawLine(x, y2, x2, y2, Toolkit.getColor("color.secondary2"));
        }
        super.draw(canvas);
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
    }

    public void objectActionResult(NakedObject result, Location at) {
        NakedObject target;
        OneToManyField internalCollectionContent = (OneToManyField)this.getContent();
        OneToManyAssociation field = internalCollectionContent.getOneToManyAssociation();
        Consent valid = field.isValidToAdd(target = ((ObjectContent)this.getParent().getContent()).getObject(), result);
        if (valid.isAllowed()) {
            field.addElement(target, result);
        }
        super.objectActionResult(result, at);
    }

    public String toString() {
        return "InternalCollectionBorder/" + this.wrappedView;
    }
}

