/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.table;

import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.CollectionContent;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.viewer.basic.ResizeDrag;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Shape;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.table.TableAxis;
import org.nakedobjects.plugins.dndviewer.viewer.table.TableRowBorder;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

public class TableHeader
extends AbstractView {
    private final int height = VPADDING + Toolkit.getText("text.label").getTextHeight() + VPADDING;
    private int resizeColumn;

    public TableHeader(Content content, ViewAxis axis) {
        super(content, null, axis);
    }

    public void firstClick(Click click) {
        if (click.getLocation().getY() <= this.height) {
            TableAxis axis = (TableAxis)this.getViewAxis();
            int column = axis.getColumnAt(click.getLocation().getX()) - 1;
            if (column == -2) {
                super.firstClick(click);
            } else if (column == -1) {
                ((CollectionContent)((Object)this.getContent())).setOrderByElement();
                this.invalidateContent();
            } else {
                NakedObjectAssociation field = axis.getFieldForColumn(column);
                ((CollectionContent)((Object)this.getContent())).setOrderByField(field);
                this.invalidateContent();
            }
        } else {
            super.firstClick(click);
        }
    }

    public void invalidateContent() {
        this.getParent().invalidateContent();
    }

    public Size getMaximumSize() {
        return new Size(-1, this.height);
    }

    public Drag dragStart(DragStart drag) {
        if (this.isOverColumnBorder(drag.getLocation())) {
            TableAxis axis = (TableAxis)this.getViewAxis();
            this.resizeColumn = axis.getColumnBorderAt(drag.getLocation().getX());
            Bounds resizeArea = new Bounds(this.getView().getAbsoluteLocation(), this.getSize());
            resizeArea.translate(this.getView().getPadding().getLeft(), this.getView().getPadding().getTop());
            if (this.resizeColumn == 0) {
                resizeArea.setWidth(axis.getHeaderOffset());
            } else {
                resizeArea.translate(axis.getLeftEdge(this.resizeColumn - 1), 0);
                resizeArea.setWidth(axis.getColumnWidth(this.resizeColumn - 1));
            }
            Size minimumSize = new Size(70, 0);
            return new ResizeDrag(this, resizeArea, 4, minimumSize, null);
        }
        if (drag.getLocation().getY() <= this.height) {
            return null;
        }
        return super.dragStart(drag);
    }

    public void dragTo(InternalDrag drag) {
        if (drag.getOverlay() == null) {
            throw new NakedObjectException("No overlay for drag: " + drag);
        }
        int newWidth = drag.getOverlay().getSize().getWidth();
        newWidth = Math.max(70, newWidth);
        this.getViewManager().getSpy().addAction("Resize column to " + newWidth);
        TableAxis axis = (TableAxis)this.getViewAxis();
        if (this.resizeColumn == 0) {
            axis.setOffset(newWidth);
        } else {
            axis.setWidth(this.resizeColumn - 1, newWidth);
        }
        axis.invalidateLayout();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas.createSubcanvas());
        int y = VPADDING + Toolkit.getText("text.label").getAscent();
        TableAxis axis = (TableAxis)this.getViewAxis();
        int x = axis.getHeaderOffset() - 2;
        if (((CollectionContent)((Object)this.getContent())).getOrderByElement()) {
            this.drawOrderIndicator(canvas, axis, x - 10);
        }
        Color secondary1 = Toolkit.getColor("color.secondary1");
        canvas.drawLine(0, this.height - 1, this.getSize().getWidth() - 1, this.height - 1, secondary1);
        canvas.drawLine(x, 0, x, this.getSize().getHeight() - 1, secondary1);
        ++x;
        int columns = axis.getColumnCount();
        NakedObjectAssociation fieldSortOrder = ((CollectionContent)((Object)this.getContent())).getFieldSortOrder();
        for (int i = 0; i < columns; ++i) {
            if (fieldSortOrder == axis.getFieldForColumn(i)) {
                this.drawOrderIndicator(canvas, axis, x + axis.getColumnWidth(i) - 10);
            }
            canvas.drawLine(x, 0, x, this.getSize().getHeight() - 1, Toolkit.getColor("color.black"));
            Canvas headerCanvas = canvas.createSubcanvas(x, 0, axis.getColumnWidth(i) - 1, this.height);
            headerCanvas.drawText(axis.getColumnName(i), HPADDING, y, secondary1, Toolkit.getText("text.label"));
            x += axis.getColumnWidth(i);
        }
        Color secondary2 = Toolkit.getColor("color.secondary2");
        canvas.drawLine(x, 0, x, this.getSize().getHeight() - 1, secondary2);
        canvas.drawRectangle(0, this.height, this.getSize().getWidth() - 1, this.getSize().getHeight() - this.height - 1, secondary2);
    }

    private void drawOrderIndicator(Canvas canvas, TableAxis axis, int x) {
        Shape arrow = new Shape();
        if (((CollectionContent)((Object)this.getContent())).getReverseSortOrder()) {
            arrow.addVertex(0, 7);
            arrow.addVertex(3, 0);
            arrow.addVertex(6, 7);
        } else {
            arrow.addVertex(0, 0);
            arrow.addVertex(6, 0);
            arrow.addVertex(3, 7);
        }
        canvas.drawShape(arrow, x, 3, Toolkit.getColor("color.secondary2"));
    }

    public View identify(Location location) {
        this.getViewManager().getSpy().addTrace("Identify over column " + location);
        if (this.isOverColumnBorder(location)) {
            this.getViewManager().getSpy().addAction("Identified over column ");
            return this.getView();
        }
        return super.identify(location);
    }

    private boolean isOverColumnBorder(Location at) {
        int x = at.getX();
        TableAxis axis = (TableAxis)this.getViewAxis();
        return axis.getColumnBorderAt(x) >= 0;
    }

    public void mouseMoved(Location at) {
        if (this.isOverColumnBorder(at)) {
            this.getFeedbackManager().showResizeRightCursor();
        } else {
            super.mouseMoved(at);
            this.getFeedbackManager().showDefaultCursor();
        }
    }

    public void secondClick(Click click) {
        if (this.isOverColumnBorder(click.getLocation())) {
            TableAxis axis = (TableAxis)this.getViewAxis();
            int column = axis.getColumnBorderAt(click.getLocation().getX()) - 1;
            if (column == -1) {
                View[] subviews = this.getSubviews();
                for (int i = 0; i < subviews.length; ++i) {
                    View row = subviews[i];
                    axis.ensureOffset(((TableRowBorder)row).requiredTitleWidth());
                }
            } else {
                View[] subviews = this.getSubviews();
                int max = 0;
                for (int i = 0; i < subviews.length; ++i) {
                    View row = subviews[i];
                    View cell = row.getSubviews()[column];
                    max = Math.max(max, cell.getRequiredSize(new Size()).getWidth());
                }
                axis.setWidth(column, max);
            }
            axis.invalidateLayout();
        } else {
            super.secondClick(click);
        }
    }

    public String toString() {
        return "TableHeader";
    }

    public ViewAreaType viewAreaType(Location at) {
        int x = at.getX();
        TableAxis axis = (TableAxis)this.getViewAxis();
        if (axis.getColumnBorderAt(x) >= 0) {
            return ViewAreaType.INTERNAL;
        }
        return super.viewAreaType(at);
    }
}

