/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.calendar;

import java.util.Date;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.value.DateValueFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractBuilderDecorator;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarAxis;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarDisplay;

public class CalendarLayout
extends AbstractBuilderDecorator {
    public CalendarLayout(ViewBuilder design) {
        super(design);
    }

    public Size getRequiredSize(View view) {
        CalendarAxis calendarAxis = (CalendarAxis)view.getViewAxis();
        CalendarDisplay calendarDisplay = calendarAxis.getCalendarDisplay();
        return calendarDisplay.getRequiredSize();
    }

    public void layout(View view, Size maximumSize) {
        CalendarAxis calendarAxis = (CalendarAxis)view.getViewAxis();
        CalendarDisplay calendarDisplay = calendarAxis.getCalendarDisplay();
        Size size = view.getSize();
        size.contract(view.getPadding());
        Size blockSize = calendarDisplay.getBlockSize(size);
        int width = blockSize.getWidth();
        int height = blockSize.getHeight();
        View[] subviews = view.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            View v = subviews[i];
            NakedObjectAssociation dateField = this.findDate(v);
            if (dateField == null) continue;
            DateValueFacet facet = (DateValueFacet)dateField.getFacet(DateValueFacet.class);
            NakedObject field = dateField.get(v.getContent().getNaked());
            Date date = facet.dateValue(field);
            calendarDisplay.layoutDate(v, date, width, height);
        }
    }

    private NakedObjectAssociation findDate(View view) {
        Content c = view.getContent();
        NakedObject adapter = c.getNaked();
        NakedObjectSpecification spec = adapter.getSpecification();
        NakedObjectAssociation[] fields = spec.getAssociations();
        for (int i = 0; i < fields.length; ++i) {
            Facet facet = fields[i].getFacet(DateValueFacet.class);
            if (facet == null) continue;
            return fields[i];
        }
        return null;
    }
}

