/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.calendar;

import java.util.Calendar;
import java.util.Date;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarConstants;
import org.nakedobjects.plugins.dndviewer.viewer.view.calendar.CalendarDisplay;

public class MonthDisplay
implements CalendarDisplay {
    private int overDay;
    private final Calendar focusDate = Calendar.getInstance();

    public void draw(Canvas canvas, Size size) {
        this.monthGrid(canvas, size);
    }

    public boolean drop(ContentDrag drag, Size size) {
        int day = this.dayAtPointerForMonthView(drag, size);
        NakedObject adapter = drag.getSourceContent().getNaked();
        return day > 0;
    }

    private int dayAtPointerForMonthView(ContentDrag drag, Size size) {
        int width = size.getWidth() / 7;
        int height = size.getHeight() / 5;
        Location pointer = drag.getTargetLocation();
        int column = pointer.getX() / width;
        int row = pointer.getY() / height;
        int day = row * 7 + column + 1;
        System.out.println(pointer + " " + day);
        return day;
    }

    private void monthGrid(Canvas canvas, Size size) {
        int width = size.getWidth() / 7;
        int height = size.getHeight() / 5;
        canvas.drawSolidRectangle(0, 0, width * 2, height * 5, CalendarConstants.weekendColor);
        int day = 1 - this.getMonthOffSet();
        int y = 4;
        for (int rows = 0; rows < 5; ++rows) {
            canvas.drawLine(0, rows * height, width * 7, rows * height, CalendarConstants.lineColor);
            int x = 4;
            for (int cols = 0; cols < 7; ++cols) {
                if (day > 0) {
                    canvas.drawText("" + day, x, y + CalendarConstants.style.getAscent(), CalendarConstants.textColor, CalendarConstants.style);
                }
                ++day;
                x += width;
            }
            y += height;
        }
        for (int cols = 0; cols < 7; ++cols) {
            canvas.drawLine(cols * width, 0, cols * width, height * 5, CalendarConstants.lineColor);
        }
        if (this.overDay > 0) {
            y = this.overDay / 7 * height;
            int x = this.overDay % 7 * width;
            canvas.drawRectangle(x, y, width, height, Toolkit.getColor("color.primary1"));
        }
    }

    public void firstClick(Click click, Size size) {
        if (new Bounds(0, 0, 10, 10).contains(click.getLocation())) {
            this.focusDate.add(2, -1);
        } else if (new Bounds(size.getWidth() - 10, size.getHeight() - 10, 10, 10).contains(click.getLocation())) {
            this.focusDate.add(2, 1);
        }
    }

    public Size getBlockSize(Size size) {
        return new Size(size.getWidth() / 7, size.getHeight() / 5);
    }

    public void layoutDate(View v, Date date, int width, int height) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        int col = (day - 1) % 7;
        int row = (day - 1) / 7;
        int x = width * col + 20;
        int y = height * row + 5;
        v.layout(new Size(width - 19, height - 6));
        v.setLocation(new Location(x, y));
        v.setSize(new Size(width - 19, height - 6));
    }

    private int getMonthOffSet() {
        Calendar c = Calendar.getInstance();
        c.set(this.focusDate.get(1), this.focusDate.get(2), 1);
        int offset = c.get(7);
        return offset;
    }

    public Size getRequiredSize() {
        return new Size(560, 250);
    }
}

