/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.dialog;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.plugins.dndviewer.ActionContent;
import org.nakedobjects.plugins.dndviewer.BackgroundTask;
import org.nakedobjects.plugins.dndviewer.BackgroundThread;
import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.LabelAxis;
import org.nakedobjects.plugins.dndviewer.ObjectParameter;
import org.nakedobjects.plugins.dndviewer.ParameterContent;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.TextParseableParameter;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewFactory;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractButtonAction;
import org.nakedobjects.plugins.dndviewer.viewer.action.CancelAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.ButtonBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.DroppableLabelBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.IconBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.LabelBorder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.StackLayout;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.view.dialog.ActionDialogFocusManager;
import org.nakedobjects.plugins.dndviewer.viewer.view.dialog.ActionFieldBuilder;

public class ActionDialogSpecification
extends AbstractCompositeViewSpecification {
    private static final Logger LOG = Logger.getLogger(ActionDialogSpecification.class);

    public ActionDialogSpecification() {
        this.builder = new StackLayout(new ActionFieldBuilder(new DialogFormSubviews()));
    }

    public boolean canDisplay(Content content, ViewRequirement requirement) {
        return content instanceof ActionContent;
    }

    protected ViewAxis axis(Content content) {
        return new LabelAxis();
    }

    protected View decorateView(View view) {
        ButtonAction[] actions = new ButtonAction[]{new ExecuteAndCloseAction(), new CancelAction()};
        ButtonBorder buttonBorder = new ButtonBorder(actions, new IconBorder(view));
        buttonBorder.setFocusManager(new ActionDialogFocusManager(buttonBorder));
        return buttonBorder;
    }

    public String getName() {
        return "Action Dialog";
    }

    private static class ExecuteAndCloseAction
    extends ExecuteAction {
        public ExecuteAndCloseAction() {
            super("OK");
        }

        public void execute(Workspace workspace, View view, Location at) {
            LOG.debug((Object)("executing action " + this));
            view.dispose();
            LOG.debug((Object)"  ... disposed view, now executing");
            super.execute(workspace, view, at);
            view.getViewManager().setKeyboardFocus(workspace);
        }

        protected void move(Location at) {
        }
    }

    private static class ExecuteAction
    extends AbstractButtonAction {
        public ExecuteAction() {
            this("Apply");
        }

        public ExecuteAction(String name) {
            super(name, true);
        }

        public Consent disabled(View view) {
            View[] subviews = view.getSubviews();
            StringBuffer missingFields = new StringBuffer();
            StringBuffer invalidFields = new StringBuffer();
            for (int i = 0; i < subviews.length; ++i) {
                String parameterName;
                boolean isEmpty;
                View field = subviews[i];
                ParameterContent content = (ParameterContent)field.getContent();
                boolean bl = isEmpty = content.getNaked() == null;
                if (content.isRequired() && isEmpty) {
                    parameterName = content.getParameterName();
                    if (missingFields.length() > 0) {
                        missingFields.append(", ");
                    }
                    missingFields.append(parameterName);
                    continue;
                }
                if (!field.getState().isInvalid()) continue;
                parameterName = content.getParameterName();
                if (invalidFields.length() > 0) {
                    invalidFields.append(", ");
                }
                invalidFields.append(parameterName);
            }
            if (missingFields.length() > 0) {
                return new Veto(String.format("Fields needed: %s", missingFields));
            }
            if (invalidFields.length() > 0) {
                return new Veto(String.format("Invalid fields: %s", invalidFields));
            }
            ActionContent actionContent = (ActionContent)view.getContent();
            return actionContent.disabled();
        }

        public void execute(final Workspace workspace, final View view, Location at) {
            BackgroundTask task = new BackgroundTask(){

                public void execute() {
                    ActionContent actionContent = (ActionContent)view.getContent();
                    NakedObject result = actionContent.execute();
                    LOG.debug((Object)("action invoked with result " + result));
                    if (result != null) {
                        Location dialogLocation = view.getAbsoluteLocation();
                        ExecuteAction.this.move(dialogLocation);
                        CollectionFacet facet = (CollectionFacet)result.getSpecification().getFacet(CollectionFacet.class);
                        if (facet != null && facet.size(result) == 1) {
                            result = facet.firstElement(result);
                        }
                        View newView = workspace.addWindowFor(result, dialogLocation);
                        view.getViewManager().setKeyboardFocus(newView);
                    }
                    view.getViewManager().disposeUnneededViews();
                    view.getFeedbackManager().showMessagesAndWarnings();
                }

                public String getName() {
                    return ((ActionContent)view.getContent()).getActionName();
                }

                public String getDescription() {
                    return "Running action " + this.getName() + " on  " + view.getContent().getNaked();
                }
            };
            LOG.debug((Object)("  ... created task " + task));
            BackgroundThread.run(view, task);
        }

        protected void move(Location at) {
            at.move(30, 60);
        }
    }

    private static class DialogFormSubviews
    implements SubviewSpec {
        private DialogFormSubviews() {
        }

        public View createSubview(Content content, ViewAxis axis, int fieldNumber) {
            if (content instanceof TextParseableParameter) {
                ViewFactory factory = Toolkit.getViewFactory();
                return factory.createView(new ViewRequirement(content, 1));
            }
            if (content instanceof ObjectParameter) {
                ViewFactory factory = Toolkit.getViewFactory();
                return factory.createView(new ViewRequirement(content, axis, 1));
            }
            return null;
        }

        public View decorateSubview(View fieldView) {
            if (fieldView.getContent() instanceof ObjectParameter) {
                return DroppableLabelBorder.createObjectParameterLabelBorder(fieldView);
            }
            return LabelBorder.createValueParameterLabelBorder(fieldView);
        }
    }
}

