/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.field;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.TextParseableContent;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.AbstractField;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.TextField;

public abstract class TextParseableFieldAbstract
extends AbstractField {
    private static final Logger LOG = Logger.getLogger(TextField.class);

    protected TextParseableFieldAbstract(Content content, ViewSpecification design, ViewAxis axis) {
        super(content, design, axis);
    }

    protected boolean provideClearCopyPaste() {
        return true;
    }

    protected void pasteFromClipboard() {
        try {
            String text = (String)this.getViewManager().getClipboard(String.class);
            TextParseableContent content = (TextParseableContent)this.getContent();
            content.parseTextEntry(text);
            content.entryComplete();
            LOG.debug((Object)("pasted " + text));
        }
        catch (Throwable e) {
            LOG.error((Object)("invalid paste operation " + e));
        }
    }

    protected boolean cantClear() {
        TextParseableContent field = (TextParseableContent)this.getContent();
        return !field.canClear();
    }

    protected void clear() {
        try {
            TextParseableContent content = (TextParseableContent)this.getContent();
            content.parseTextEntry("");
            content.entryComplete();
            LOG.debug((Object)"cleared");
        }
        catch (Throwable e) {
            LOG.error((Object)("invalid paste operation " + e));
        }
    }

    protected void copyToClipboard() {
        TextParseableContent content = (TextParseableContent)this.getContent();
        NakedObject object = content.getNaked();
        if (object != null) {
            String text = object.titleString();
            this.getViewManager().setClipboard(text, String.class);
            LOG.debug((Object)("copied " + text));
        }
    }

    public boolean isEmpty() {
        TextParseableContent content = (TextParseableContent)this.getContent();
        return content.isEmpty();
    }

    public Consent canChangeValue() {
        TextParseableContent cont = (TextParseableContent)this.getContent();
        return cont.isEditable();
    }

    protected void saveValue(NakedObject value) {
        this.parseEntry(value.titleString());
    }

    protected void parseEntry(String entryText) {
        TextParseableContent content = (TextParseableContent)this.getContent();
        content.parseTextEntry(entryText);
        content.entryComplete();
    }
}

