/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.help;

import org.nakedobjects.metamodel.commons.about.AboutNakedObjects;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.NullContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

public class AboutView
extends AbstractView {
    private static final int MAX_WIDTH = 300;
    private final int linePadding = -2;
    private final int noticePadding = 45;
    private final int margin = 14;
    private final Image image = ImageFactory.getInstance().loadImage(AboutNakedObjects.getImageName());
    private final int left;

    public AboutView() {
        super(new NullContent());
        this.left = 45;
        this.setContent(new NullContent(AboutNakedObjects.getFrameworkName()));
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Text titleStyle = Toolkit.getText("text.title");
        Text normalStyle = Toolkit.getText("text.label");
        Color color = Toolkit.getColor("color.black");
        canvas.clearBackground(this, Toolkit.getColor("color.white"));
        canvas.drawRectangleAround(this, Toolkit.getColor("color.secondary1"));
        if (this.showingImage()) {
            canvas.drawImage(this.image, 14, 14);
        }
        int line = 14 + this.image.getHeight() + 45 + normalStyle.getAscent();
        String text = AboutNakedObjects.getApplicationName();
        if (text != null) {
            canvas.drawText(text, this.left, line, 300, color, titleStyle);
            line += titleStyle.stringHeight(text, 300) + titleStyle.getLineSpacing() + -2;
        }
        if ((text = AboutNakedObjects.getApplicationCopyrightNotice()) != null) {
            canvas.drawText(text, this.left, line, 300, color, normalStyle);
            line += normalStyle.stringHeight(text, 300) + normalStyle.getLineSpacing() + -2;
        }
        if ((text = AboutNakedObjects.getApplicationVersion()) != null) {
            canvas.drawText(text, this.left, line, 300, color, normalStyle);
            line += normalStyle.stringHeight(text, 300) + normalStyle.getLineSpacing() + -2;
            line += 2 * normalStyle.getLineHeight();
        }
        text = AboutNakedObjects.getFrameworkName();
        canvas.drawText(text, this.left, line, 300, color, titleStyle);
        line += titleStyle.stringHeight(text, 300) + titleStyle.getLineSpacing() + -2;
        text = AboutNakedObjects.getFrameworkCopyrightNotice();
        canvas.drawText(text, this.left, line, 300, color, normalStyle);
        canvas.drawText(this.frameworkVersion(), this.left, line += normalStyle.stringHeight(text, 300) + normalStyle.getLineSpacing() + -2, 300, color, normalStyle);
    }

    private String frameworkVersion() {
        return AboutNakedObjects.getFrameworkVersion();
    }

    private boolean showingImage() {
        return this.image != null;
    }

    public Size getMaximumSize() {
        Text titleStyle = Toolkit.getText("text.title");
        Text normalStyle = Toolkit.getText("text.label");
        int height = 0;
        String text = AboutNakedObjects.getFrameworkName();
        height += titleStyle.stringHeight(text, 300) + titleStyle.getLineSpacing() + -2;
        int width = titleStyle.stringWidth(text, 300);
        text = AboutNakedObjects.getFrameworkCopyrightNotice();
        height += normalStyle.stringHeight(text, 300) + normalStyle.getLineSpacing() + -2;
        width = Math.max(width, normalStyle.stringWidth(text, 300));
        text = this.frameworkVersion();
        height += normalStyle.stringHeight(text, 300) + normalStyle.getLineSpacing() + -2;
        width = Math.max(width, normalStyle.stringWidth(text, 300));
        text = AboutNakedObjects.getApplicationName();
        if (text != null) {
            height += titleStyle.stringHeight(text, 300) + titleStyle.getLineSpacing() + -2;
            width = Math.max(width, titleStyle.stringWidth(text, 300));
        }
        if ((text = AboutNakedObjects.getApplicationCopyrightNotice()) != null) {
            height += normalStyle.stringHeight(text, 300) + normalStyle.getLineSpacing() + -2;
            width = Math.max(width, normalStyle.stringWidth(text, 300));
        }
        if ((text = AboutNakedObjects.getApplicationVersion()) != null) {
            height += normalStyle.stringHeight(text, 300) + normalStyle.getLineSpacing() + -2;
            width = Math.max(width, normalStyle.stringWidth(text, 300));
        }
        height += 45;
        if (this.showingImage()) {
            height += this.image.getHeight();
            width = Math.max(this.image.getWidth(), width);
        }
        return new Size(14 + width + 14, 14 + height + 14);
    }

    public void firstClick(Click click) {
    }
}

