/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.simple;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.ConsentAbstract;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.Feedback;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.InternalDrag;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAreaType;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.Viewer;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.action.CloseAllViewsForObjectOption;
import org.nakedobjects.plugins.dndviewer.viewer.action.CloseAllViewsOption;
import org.nakedobjects.plugins.dndviewer.viewer.action.CloseViewOption;
import org.nakedobjects.plugins.dndviewer.viewer.action.OpenViewOption;
import org.nakedobjects.plugins.dndviewer.viewer.action.ReplaceViewOption;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.undo.UndoStack;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.NonBuildingSpecification;

public abstract class AbstractView
implements View {
    private static final UserAction CLOSE_ALL_OPTION = new CloseAllViewsOption();
    private static final UserAction CLOSE_OPTION = new CloseViewOption();
    private static final UserAction CLOSE_VIEWS_FOR_OBJECT = new CloseAllViewsForObjectOption();
    private static final Logger LOG = Logger.getLogger(AbstractView.class);
    private static int nextId = 0;
    private Content content;
    private int height;
    private int id = 0;
    private View parent;
    private ViewSpecification specification;
    private final ViewState state;
    private View view;
    private ViewAxis viewAxis;
    private int width;
    private int x;
    private int y;

    protected AbstractView(Content content) {
        this(content, null, null);
    }

    protected AbstractView(Content content, ViewAxis axis) {
        this(content, null, axis);
    }

    protected AbstractView(Content content, ViewSpecification specification, ViewAxis axis) {
        if (content == null) {
            throw new IllegalArgumentException("Content not specified");
        }
        this.assignId();
        this.content = content;
        this.specification = specification;
        this.viewAxis = axis;
        this.state = new ViewState();
        this.view = this;
    }

    public void addView(View view) {
        throw new NakedObjectException("Can't add views to " + this);
    }

    protected void assignId() {
        this.id = nextId++;
    }

    public Consent canChangeValue() {
        return Veto.DEFAULT;
    }

    public boolean canFocus() {
        return true;
    }

    public boolean contains(View view) {
        View[] subviews = this.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            if (subviews[i] != view && (subviews[i] == null || !subviews[i].contains(view))) continue;
            return true;
        }
        return false;
    }

    public boolean containsFocus() {
        if (this.hasFocus()) {
            return true;
        }
        View[] subviews = this.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            if (subviews[i] == null || !subviews[i].containsFocus()) continue;
            return true;
        }
        return false;
    }

    public void contentMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("color.background.menu.content"));
        Content content = this.getContent();
        if (content != null) {
            content.contentMenuOptions(options);
        }
    }

    public void debug(DebugString debug) {
        View p;
        String name = this.getClass().getName();
        debug.appendln("Root", (Object)(name.substring(name.lastIndexOf(46) + 1) + this.getId()));
        debug.indent();
        debug.appendln("set size", (Object)this.getSize());
        debug.appendln("maximum", (Object)this.getMaximumSize());
        debug.appendln("required", (Object)this.getRequiredSize(new Size()));
        debug.appendln("w/in parent", (Object)this.getRequiredSize(this.getParent() == null ? new Size() : this.getParent().getSize()));
        debug.appendln("parent's", (Object)(this.getParent() == null ? new Size() : this.getParent().getSize()));
        debug.appendln("padding", (Object)this.getPadding());
        debug.appendln("base line", (Object)(this.getBaseline() + "px"));
        debug.unindent();
        debug.appendln();
        debug.appendTitle("Specification");
        if (this.specification == null) {
            debug.append((Object)"\none");
        } else {
            debug.appendln(this.specification.getName());
            debug.appendln("  " + this.specification.getClass().getName());
            debug.appendln("  " + (this.specification.isOpen() ? "open" : "closed"));
            debug.appendln("  " + (this.specification.isReplaceable() ? "replaceable" : "non-replaceable"));
            debug.appendln("  " + (this.specification.isSubView() ? "subview" : "main view"));
        }
        debug.appendln();
        debug.appendTitle("View");
        debug.appendln("Changable", (Object)this.canChangeValue());
        debug.appendln();
        debug.appendln("Focus", (Object)(this.canFocus() ? "focusable" : "non-focusable"));
        debug.appendln("Has focus", this.hasFocus());
        debug.appendln("Contains focus", this.containsFocus());
        debug.appendln("Focus manager", (Object)this.getFocusManager());
        debug.appendln();
        debug.appendln("Self", (Object)this.getView());
        debug.appendln("Axis", (Object)this.getViewAxis());
        debug.appendln("State", (Object)this.getState());
        debug.appendln("Location", (Object)this.getLocation());
        debug.appendln("Workspace", (Object)this.getWorkspace());
        debug.appendln("Parent hierarchy:" + (p == null ? "none" : ""));
        debug.indent();
        for (p = this.getParent(); p != null; p = p.getParent()) {
            debug.appendln(p.toString());
        }
        debug.unindent();
        debug.appendln();
        debug.appendln();
        debug.appendln();
        debug.appendTitle("View structure");
        debug.appendln(this.getSpecification().getName().toUpperCase());
        this.debugStructure(debug);
    }

    public void debugStructure(DebugString b) {
        b.appendln("Content", this.getContent() == null ? "none" : this.getContent());
        b.appendln("Required size ", (Object)this.getRequiredSize(new Size()));
        b.appendln("Bounds", (Object)this.getBounds());
        b.appendln("Baseline", (long)this.getBaseline());
        b.appendln("Location", (Object)this.getAbsoluteLocation());
        View[] views = this.getSubviews();
        b.indent();
        for (int i = 0; i < views.length; ++i) {
            View subview = views[i];
            b.appendln();
            b.appendln(subview.getSpecification().getName().toUpperCase());
            b.appendln("View", (Object)subview);
            subview.debugStructure(b);
        }
        b.unindent();
    }

    public void dispose() {
        View parent = this.getParent();
        if (parent != null) {
            parent.removeView(this.getView());
        }
    }

    public void drag(InternalDrag drag) {
    }

    public void drag(ContentDrag contentDrag) {
    }

    public void dragCancel(InternalDrag drag) {
        this.getFeedbackManager().showDefaultCursor();
    }

    public View dragFrom(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.dragFrom(location);
        }
        return null;
    }

    public void dragIn(ContentDrag drag) {
    }

    public void dragOut(ContentDrag drag) {
    }

    public Drag dragStart(DragStart drag) {
        View subview = this.subviewFor(drag.getLocation());
        if (subview != null) {
            drag.subtract(subview.getLocation());
            return subview.dragStart(drag);
        }
        return null;
    }

    public void dragTo(InternalDrag drag) {
    }

    public void draw(Canvas canvas) {
        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(this.getSize()), this.getBaseline(), Toolkit.getColor("color.debug.bounds.view"));
        }
    }

    public void drop(ContentDrag drag) {
    }

    public void drop(ViewDrag drag) {
    }

    public void editComplete(boolean moveFocus, boolean toNextField) {
    }

    public void entered() {
        String description;
        Content cont = this.getContent();
        if (cont != null && (description = cont.getDescription()) != null && !"".equals(description)) {
            this.getFeedbackManager().setViewDetail(description);
        }
    }

    public void exited() {
    }

    public void firstClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.firstClick(click);
        }
    }

    public void focusLost() {
    }

    public void focusReceived() {
    }

    public Location getAbsoluteLocation() {
        View parent = this.getParent();
        if (parent == null) {
            return this.getLocation();
        }
        Location location = parent.getAbsoluteLocation();
        this.getViewManager().getSpy().addTrace(this, "parent location", location);
        location.add(this.x, this.y);
        this.getViewManager().getSpy().addTrace(this, "plus view's location", location);
        Padding pad = parent.getPadding();
        location.add(pad.getLeft(), pad.getTop());
        this.getViewManager().getSpy().addTrace(this, "plus view's padding", location);
        return location;
    }

    public int getBaseline() {
        return 0;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public Content getContent() {
        return this.content;
    }

    public FocusManager getFocusManager() {
        return this.getParent() == null ? null : this.getParent().getFocusManager();
    }

    public int getId() {
        return this.id;
    }

    public Location getLocation() {
        return new Location(this.x, this.y);
    }

    public Padding getPadding() {
        return new Padding(0, 0, 0, 0);
    }

    public final View getParent() {
        return this.parent == null ? null : this.parent.getView();
    }

    public Size getRequiredSize(Size maximumSize) {
        return this.getMaximumSize();
    }

    public Size getMaximumSize() {
        return new Size();
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }

    public ViewSpecification getSpecification() {
        if (this.specification == null) {
            this.specification = new NonBuildingSpecification(this);
        }
        return this.specification;
    }

    public ViewState getState() {
        return this.state;
    }

    public View[] getSubviews() {
        return new View[0];
    }

    public final View getView() {
        return this.view;
    }

    public final ViewAxis getViewAxis() {
        return this.viewAxis;
    }

    public Viewer getViewManager() {
        return Toolkit.getViewer();
    }

    public Feedback getFeedbackManager() {
        return Toolkit.getFeedbackManager();
    }

    public Workspace getWorkspace() {
        return this.getParent() == null ? null : this.getParent().getWorkspace();
    }

    public boolean hasFocus() {
        return this.getViewManager().hasFocus(this.getView());
    }

    public View identify(Location location) {
        View subview = this.subviewFor(location);
        if (subview == null) {
            this.getViewManager().getSpy().addTrace(this, "mouse location within node view", location);
            this.getViewManager().getSpy().addTrace("----");
            return this.getView();
        }
        location.subtract(subview.getLocation());
        return subview.identify(location);
    }

    public void invalidateContent() {
    }

    public void invalidateLayout() {
        View parent = this.getParent();
        if (parent != null) {
            parent.invalidateLayout();
        }
    }

    public void keyPressed(KeyboardAction key) {
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public void layout(Size maximumSize) {
    }

    public void limitBoundsWithin(Bounds containerBounds) {
        Bounds contentBounds = this.getView().getBounds();
        if (containerBounds.limitBounds(contentBounds)) {
            this.getView().setBounds(contentBounds);
        }
    }

    public void limitBoundsWithin(Size size) {
        int w = this.getView().getSize().getWidth();
        int h = this.getView().getSize().getHeight();
        int x = this.getView().getLocation().getX();
        int y = this.getView().getLocation().getY();
        if (x + w > size.getWidth()) {
            x = size.getWidth() - w;
        }
        if (x < 0) {
            x = 0;
        }
        if (y + h > size.getHeight()) {
            y = size.getHeight() - h;
        }
        if (y < 0) {
            y = 0;
        }
        this.getView().setLocation(new Location(x, y));
    }

    public void markDamaged() {
        this.markDamaged(this.getView().getBounds());
    }

    public void markDamaged(Bounds bounds) {
        View parent = this.getParent();
        if (parent == null) {
            this.getViewManager().markDamaged(bounds);
        } else {
            Location pos = parent.getLocation();
            bounds.translate(pos.getX(), pos.getY());
            Padding pad = parent.getPadding();
            bounds.translate(pad.getLeft(), pad.getTop());
            parent.markDamaged(bounds);
        }
    }

    public void mouseDown(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.mouseDown(click);
        }
    }

    public void mouseMoved(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            subview.mouseMoved(location);
        }
    }

    public void mouseUp(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.mouseUp(click);
        }
    }

    public void objectActionResult(NakedObject result, Location at) {
        this.getWorkspace().addWindowFor(result, at);
    }

    public View pickupContent(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.pickupView(location);
        }
        return Toolkit.getViewFactory().createDragViewOutline(this.getView());
    }

    public View pickupView(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.pickupView(location);
        }
        return null;
    }

    public void print(Canvas canvas) {
        this.draw(canvas);
    }

    public void refresh() {
    }

    public void removeView(View view) {
        throw new NakedObjectException();
    }

    protected void replaceOptions(Enumeration possibleViews, UserActionSet options) {
        while (possibleViews.hasMoreElements()) {
            ViewSpecification specification = (ViewSpecification)possibleViews.nextElement();
            if (specification == this.getSpecification() || this.view.getParent() != this.view.getWorkspace() || this.view.getClass() == this.getClass()) continue;
            ReplaceViewOption viewAs = new ReplaceViewOption(specification);
            options.add(viewAs);
        }
    }

    public void replaceView(View toReplace, View replacement) {
        throw new NakedObjectException();
    }

    public void secondClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.secondClick(click);
        }
    }

    public void setBounds(Bounds bounds) {
        this.x = bounds.getX();
        this.y = bounds.getY();
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
    }

    public void setFocusManager(FocusManager focusManager) {
        throw new UnexpectedCallException();
    }

    protected void setContent(Content content) {
        this.content = content;
    }

    public void setLocation(Location location) {
        this.x = location.getX();
        this.y = location.getY();
    }

    public final void setParent(View parentView) {
        LOG.debug((Object)("set parent " + parentView + " for " + this));
        this.parent = parentView.getView();
    }

    public void setMaximumSize(Size size) {
    }

    public void setSize(Size size) {
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    protected void setSpecification(ViewSpecification specification) {
        this.specification = specification;
    }

    public final void setView(View view) {
        this.view = view;
    }

    protected void setViewAxis(ViewAxis viewAxis) {
        this.viewAxis = viewAxis;
    }

    public View subviewFor(Location location) {
        return null;
    }

    public void thirdClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.thirdClick(click);
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1) + this.getId() + ":" + this.getState() + ":" + this.getContent();
    }

    public void update(NakedObject object) {
    }

    public void updateView() {
    }

    public ViewAreaType viewAreaType(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.viewAreaType(location);
        }
        return ViewAreaType.CONTENT;
    }

    public void viewMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("color.background.menu.view"));
        Content content = this.getContent();
        if (content != null) {
            content.viewMenuOptions(options);
        }
        if (this.getParent() != null) {
            Enumeration possibleViews = Toolkit.getViewFactory().availableViews(new ViewRequirement(content, 4));
            while (possibleViews.hasMoreElements()) {
                ViewSpecification specification = (ViewSpecification)possibleViews.nextElement();
                OpenViewOption viewAs = new OpenViewOption(specification);
                options.add(viewAs);
            }
        }
        if (this.view.getSpecification() != null && this.view.getSpecification().isSubView()) {
            if (this.view.getSpecification().isReplaceable()) {
                this.replaceOptions(Toolkit.getViewFactory().availableViews(new ViewRequirement(content, 260)), options);
                this.replaceOptions(Toolkit.getViewFactory().availableViews(new ViewRequirement(content, 257)), options);
            }
        } else {
            if (this.view.getSpecification() != null && this.view.getSpecification().isReplaceable()) {
                this.replaceOptions(Toolkit.getViewFactory().availableViews(new ViewRequirement(content, 260)), options);
            }
            if (this.getParent() != null) {
                options.add(CLOSE_OPTION);
                options.add(CLOSE_ALL_OPTION);
                options.add(CLOSE_VIEWS_FOR_OBJECT);
            }
        }
        options.add(new AbstractUserAction("Refresh view", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                AbstractView.this.refresh();
            }
        });
        options.add(new AbstractUserAction("Invalidate content", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                AbstractView.this.invalidateContent();
            }
        });
        options.add(new AbstractUserAction("Invalidate layout", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                AbstractView.this.invalidateLayout();
            }
        });
        final UndoStack undoStack = this.getViewManager().getUndoStack();
        if (!undoStack.isEmpty()) {
            options.add(new AbstractUserAction("Undo " + undoStack.getNameOfUndo()){

                public Consent disabled(View component) {
                    return new ConsentAbstract("", undoStack.descriptionOfUndo()){
                        private static final long serialVersionUID = 1L;
                    };
                }

                public void execute(Workspace workspace, View view, Location at) {
                    undoStack.undoLastCommand();
                }
            });
        }
    }
}

