/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.simple;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;

public class TextView
extends AbstractView {
    private final Text style = Toolkit.getText("text.normal");
    private final Color color = Toolkit.getColor("color.black");
    private final String text;

    public TextView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        NakedObject object = content.getNaked();
        this.text = object == null ? "" : object.titleString();
    }

    public boolean canFocus() {
        return false;
    }

    public void draw(Canvas canvas) {
        canvas.drawText(this.text, HPADDING, this.getBaseline(), this.color, this.style);
    }

    public int getBaseline() {
        return this.style.getAscent() + VPADDING;
    }

    public Size getRequiredSize(Size maximumSize) {
        int width = this.style.stringWidth(this.text) + HPADDING * 2;
        int height = this.style.getTextHeight() + VPADDING * 2;
        return new Size(width, height);
    }
}

