/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.specification;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public class ServiceBorder
extends AbstractBorder {
    private static final int BORDER = 13;

    public ServiceBorder(int size, View wrappedView) {
        super(wrappedView);
        this.top = size;
        this.left = size;
        this.bottom = size;
        this.right = size + 13;
    }

    public ServiceBorder(View wrappedView) {
        this(1, wrappedView);
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)("ServiceBorder " + this.top + " pixels"));
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Color color = null;
        ViewState state = this.getState();
        boolean hasFocus = this.getViewManager().hasFocus(this.getView());
        if (hasFocus) {
            color = Toolkit.getColor("color.identified");
        } else if (state.isObjectIdentified()) {
            color = Toolkit.getColor("color.secondary2");
        }
        Size s = this.getSize();
        if (color != null) {
            if (hasFocus) {
                int xExtent = s.getWidth() - this.left;
                for (int i = 0; i < this.left; ++i) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
            } else {
                int xExtent = s.getWidth();
                for (int i = 0; i < this.left; ++i) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
                canvas.drawLine(xExtent - 13, this.left, xExtent - 13, this.left + s.getHeight(), color);
                canvas.drawSolidRectangle(xExtent - 13 + 1, this.left, 11, s.getHeight() - 2 * this.left, Toolkit.getColor("color.secondary3"));
            }
        }
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void secondClick(Click click) {
    }

    public String toString() {
        return this.wrappedView.toString() + "/ServiceBorder [" + this.getSpecification() + "]";
    }
}

