/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.text;

import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextContent;

public class CursorPosition {
    private int character;
    private int line;
    private final TextContent textContent;

    public CursorPosition(TextContent content, CursorPosition pos) {
        this(content, pos.line, pos.character);
    }

    public CursorPosition(TextContent content, int line, int afterCharacter) {
        this.textContent = content;
        this.line = line;
        this.character = afterCharacter;
    }

    public void asFor(CursorPosition pos) {
        this.line = pos.line;
        this.character = pos.character;
    }

    public void bottom() {
        this.line = this.textContent.getNoLinesOfContent() - 1;
        this.textContent.alignDisplay(this.line);
        this.end();
    }

    public void cursorAt(Location atLocation) {
        this.line = this.textContent.cursorAtLine(atLocation);
        this.character = this.textContent.cursorAtCharacter(atLocation, this.line);
        if (this.line >= this.textContent.getNoLinesOfContent()) {
            this.line = this.textContent.getNoLinesOfContent() - 1;
            this.end();
        }
    }

    public void end() {
        String text = this.textContent.getText(this.line);
        this.character = text == null ? 0 : text.length();
    }

    public int getCharacter() {
        return this.character;
    }

    public int getLine() {
        return this.line;
    }

    public void home() {
        this.character = 0;
    }

    public void left() {
        if (this.line != 0 || this.character != 0) {
            --this.character;
            if (this.character < 0) {
                --this.line;
                this.textContent.alignDisplay(this.line);
                this.end();
            }
        }
    }

    public void lineDown() {
        this.moveDown(1);
    }

    public void lineUp() {
        this.moveUp(1);
    }

    private void moveDown(int byLines) {
        int size = this.textContent.getNoLinesOfContent();
        if (this.line < size - 1) {
            this.line += byLines;
            this.line = Math.min(size - 1, this.line);
            this.character = Math.min(this.character, this.textContent.getText(this.line).length());
            this.textContent.alignDisplay(this.line);
        }
    }

    private void moveUp(int byLines) {
        if (this.line > 0) {
            this.line -= byLines;
            this.line = Math.max(0, this.line);
            this.textContent.alignDisplay(this.line);
        }
    }

    public void pageDown() {
        this.moveDown(this.textContent.getNoDisplayLines() - 1);
    }

    public void pageUp() {
        this.moveUp(this.textContent.getNoDisplayLines() - 1);
    }

    public void right() {
        this.right(1);
    }

    public void right(int characters) {
        int length = this.textContent.getText(this.line).length();
        if (this.character + characters > length) {
            if (this.line + 1 < this.textContent.getNoLinesOfContent()) {
                ++this.line;
                this.textContent.alignDisplay(this.line);
                int remainder = this.character + characters - length;
                this.character = 0;
                this.right(remainder);
            }
        } else {
            this.character += characters;
        }
    }

    public void top() {
        this.line = 0;
        this.character = 0;
        this.textContent.alignDisplay(this.line);
    }

    public String toString() {
        return "CursorPosition [line=" + this.line + ",character=" + this.character + "]";
    }

    public void wordLeft() {
        if (this.line != 0 || this.character != 0) {
            if (this.character == 0) {
                --this.line;
                this.end();
            }
            String text = this.textContent.getText(this.line);
            do {
                --this.character;
            } while (this.character >= 0 && text.charAt(this.character) == ' ');
            while (this.character >= 0 && text.charAt(this.character) != ' ') {
                --this.character;
            }
            ++this.character;
        }
    }

    public void wordRight() {
        String text = this.textContent.getText(this.line);
        int lineLength = text.length();
        if (this.line != this.textContent.getNoLinesOfContent() - 1 || this.character != lineLength - 1) {
            while (this.character < lineLength && text.charAt(this.character) == ' ') {
                ++this.character;
            }
            while (this.character < lineLength && text.charAt(this.character) != ' ') {
                ++this.character;
            }
            while (this.character < lineLength && text.charAt(this.character) == ' ') {
                ++this.character;
            }
            if (this.character >= lineLength && this.line + 1 < this.textContent.getNoLinesOfContent()) {
                ++this.line;
                this.character = 0;
            }
        }
    }

    public boolean samePosition(CursorPosition positionToCompare) {
        return this.line == positionToCompare.line && this.character == positionToCompare.character;
    }

    public boolean isBefore(CursorPosition positionToCompare) {
        return this.line < positionToCompare.line || this.line == positionToCompare.line && this.character < positionToCompare.character;
    }
}

