/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.embedded;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.plugins.headless.applib.DisabledException;
import org.nakedobjects.plugins.headless.applib.HeadlessViewer;
import org.nakedobjects.plugins.headless.applib.HiddenException;
import org.nakedobjects.plugins.headless.applib.InvalidException;
import org.nakedobjects.plugins.headless.embedded.EmbeddedContext;
import org.nakedobjects.plugins.headless.embedded.NakedObjectsMetaModel;
import org.nakedobjects.plugins.headless.embedded.dom.claim.ClaimRepositoryImpl;
import org.nakedobjects.plugins.headless.embedded.dom.employee.Employee;
import org.nakedobjects.plugins.headless.embedded.dom.employee.EmployeeRepositoryImpl;
import org.nakedobjects.plugins.headless.embedded.internal.PersistenceState;

@RunWith(value=JMock.class)
public class GivenEmbeddedViewerAndPersistentDomainObject {
    private Mockery mockery = new JUnit4Mockery();
    private EmbeddedContext mockContext;
    private AuthenticationSession mockAuthenticationSession;
    private NakedObjectsMetaModel metaModel;
    private HeadlessViewer viewer;
    private Employee employeeDO;
    private Employee employeeVO;

    @Before
    public void setUp() {
        this.employeeDO = new Employee();
        this.employeeDO.setName("Smith");
        this.mockContext = (EmbeddedContext)this.mockery.mock(EmbeddedContext.class);
        this.mockAuthenticationSession = (AuthenticationSession)this.mockery.mock(AuthenticationSession.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((EmbeddedContext)this.allowing(GivenEmbeddedViewerAndPersistentDomainObject.this.mockContext)).getPersistenceState(this.with(1.any(Employee.class)));
                this.will(1.returnValue((Object)PersistenceState.PERSISTENT));
                ((EmbeddedContext)this.allowing(GivenEmbeddedViewerAndPersistentDomainObject.this.mockContext)).getPersistenceState(this.with(1.any(String.class)));
                this.will(1.returnValue((Object)PersistenceState.STANDALONE));
                ((EmbeddedContext)this.allowing(GivenEmbeddedViewerAndPersistentDomainObject.this.mockContext)).getAuthenticationSession();
                this.will(1.returnValue((Object)GivenEmbeddedViewerAndPersistentDomainObject.this.mockAuthenticationSession));
            }
        });
        this.metaModel = new NakedObjectsMetaModel(this.mockContext, new Class[]{EmployeeRepositoryImpl.class, ClaimRepositoryImpl.class});
        this.metaModel.init();
        this.viewer = this.metaModel.getViewer();
    }

    @Test
    public void shouldBeAbleToGetViewOfDomainObject() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        Assert.assertThat((Object)this.employeeVO, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldBeAbleToReadVisibleProperty() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        Assert.assertThat((Object)this.employeeVO.getName(), (Matcher)CoreMatchers.is((Object)this.employeeDO.getName()));
    }

    @Test(expected=HiddenException.class)
    public void shouldNotBeAbleToViewHiddenProperty() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        this.employeeDO.whetherHideName = true;
        this.employeeVO.getName();
    }

    @Test
    public void shouldBeAbleToModifyEnabledPropertyUsingSetter() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        this.employeeVO.setName("Jones");
        Assert.assertThat((Object)this.employeeDO.getName(), (Matcher)CoreMatchers.is((Object)"Jones"));
        Assert.assertThat((Object)this.employeeVO.getName(), (Matcher)CoreMatchers.is((Object)this.employeeDO.getName()));
    }

    @Test(expected=DisabledException.class)
    public void shouldNotBeAbleToModifyDisabledProperty() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        this.employeeDO.reasonDisableName = "sorry, no change allowed";
        this.employeeVO.setName("Jones");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotBeAbleToModifyPropertyUsingModify() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        this.employeeVO.modifyName("Jones");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotBeAbleToModifyPropertyUsingClear() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        this.employeeVO.clearName();
    }

    @Test(expected=InvalidException.class)
    public void shouldNotBeAbleToModifyPropertyIfInvalid() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        this.employeeDO.reasonValidateName = "sorry, invalid data";
        this.employeeVO.setName("Jones");
    }

    @Test(expected=DisabledException.class)
    public void shouldNotBeAbleToModifyPropertyForTransientOnly() {
        this.employeeVO = (Employee)this.viewer.view((Object)this.employeeDO);
        this.employeeVO.setPassword("12345678");
    }

    @Ignore(value="incomplete")
    @Test
    public void shouldBeAbleToInjectIntoDomainObjects() {
        this.employeeVO.setPassword("12345678");
    }
}

