/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.embedded;

import java.util.TreeSet;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.progmodelfacets.ProgrammingModelFacets;
import org.nakedobjects.plugins.headless.embedded.EmbeddedContext;
import org.nakedobjects.plugins.headless.embedded.NakedObjectsMetaModel;
import org.nakedobjects.plugins.headless.embedded.dom.claim.ClaimRepositoryImpl;
import org.nakedobjects.plugins.headless.embedded.dom.employee.EmployeeRepositoryImpl;

@RunWith(value=JMock.class)
public class GivenMetaModelWhenShutdown {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObjectConfiguration mockConfiguration;
    private ProgrammingModelFacets mockProgrammingModelFacets;
    private FacetDecorator mockFacetDecorator;
    private ClassSubstitutor mockClassSubstitutor;
    private CollectionTypeRegistry mockCollectionTypeRegistry;
    private EmbeddedContext mockContext;
    private NakedObjectsMetaModel metaModel;

    @Before
    public void setUp() {
        this.mockContext = (EmbeddedContext)this.mockery.mock(EmbeddedContext.class);
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.mockProgrammingModelFacets = (ProgrammingModelFacets)this.mockery.mock(ProgrammingModelFacets.class);
        this.mockCollectionTypeRegistry = (CollectionTypeRegistry)this.mockery.mock(CollectionTypeRegistry.class);
        this.mockFacetDecorator = (FacetDecorator)this.mockery.mock(FacetDecorator.class);
        this.mockClassSubstitutor = (ClassSubstitutor)this.mockery.mock(ClassSubstitutor.class);
        this.metaModel = new NakedObjectsMetaModel(this.mockContext, new Class[]{EmployeeRepositoryImpl.class, ClaimRepositoryImpl.class});
    }

    @Test
    public void shouldSucceedWithoutThrowingAnyExceptions() {
        this.metaModel.init();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeConfiguration() {
        this.metaModel.init();
        this.metaModel.setConfiguration(this.mockConfiguration);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeProgrammingModelFacets() {
        this.metaModel.init();
        this.metaModel.setProgrammingModelFacets(this.mockProgrammingModelFacets);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeCollectionTypeRegistry() {
        this.metaModel.init();
        this.metaModel.setCollectionTypeRegistry(this.mockCollectionTypeRegistry);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeClassSubstitutor() {
        this.metaModel.init();
        this.metaModel.setClassSubstitutor(this.mockClassSubstitutor);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeFacetDecorators() {
        this.metaModel.init();
        this.metaModel.setFacetDecorators(new TreeSet());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotBeAbleToAddToFacetDecorators() {
        this.metaModel.init();
        this.metaModel.getFacetDecorators().add(this.mockFacetDecorator);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToInitializeAgain() {
        this.metaModel.init();
        this.metaModel.init();
    }
}

