/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.embedded.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.applib.query.Query;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.component.ApplicationScopedComponent;
import org.nakedobjects.metamodel.runtimecontext.ObjectInstantiationException;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContextAbstract;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.services.ServicesInjectorDefault;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.identifier.Identified;
import org.nakedobjects.plugins.headless.embedded.EmbeddedContext;
import org.nakedobjects.plugins.headless.embedded.internal.PersistenceState;
import org.nakedobjects.plugins.headless.embedded.internal.ServiceAdapter;
import org.nakedobjects.plugins.headless.embedded.internal.StandaloneAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeContextForEmbeddedMetaModel
extends RuntimeContextAbstract
implements ApplicationScopedComponent {
    private final EmbeddedContext context;
    private final List<Object> services;
    private List<NakedObject> serviceAdapters;
    private ServicesInjector servicesInjector;

    public RuntimeContextForEmbeddedMetaModel(EmbeddedContext context, List<Object> services) {
        this.context = context;
        this.services = services;
    }

    public void init() {
        this.serviceAdapters = this.adaptersFor(this.services);
        this.servicesInjector = new ServicesInjectorDefault();
        this.servicesInjector.setContainer(this.getContainer());
        this.servicesInjector.setServices(this.services);
    }

    public void shutdown() {
    }

    private List<NakedObject> adaptersFor(List<Object> services) {
        ArrayList<ServiceAdapter> serviceAdapters = new ArrayList<ServiceAdapter>();
        for (Object service : services) {
            NakedObjectSpecification spec = this.getSpecificationLoader().loadSpecification(service.getClass());
            serviceAdapters.add(new ServiceAdapter(spec, service));
        }
        return Collections.unmodifiableList(serviceAdapters);
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.context.getAuthenticationSession();
    }

    public NakedObject adapterFor(Object domainObject) {
        NakedObjectSpecification domainObjectSpec = this.getSpecificationLoader().loadSpecification(domainObject.getClass());
        PersistenceState persistenceState = this.context.getPersistenceState(domainObject);
        return new StandaloneAdapter(domainObjectSpec, domainObject, persistenceState);
    }

    public NakedObject adapterFor(Object domainObject, NakedObject ownerAdapter, Identified identified) {
        return this.adapterFor(domainObject);
    }

    public NakedObject getAdapterFor(Object domainObject) {
        return this.adapterFor(domainObject);
    }

    public NakedObject getAdapterFor(Oid oid) {
        throw new UnsupportedOperationException("Not supported by this implementation of RuntimeContext");
    }

    public NakedObject createTransientInstance(NakedObjectSpecification spec) {
        Object domainObject = spec.createObject(NakedObjectSpecification.CreationMode.INITIALIZE);
        return this.adapterFor(domainObject);
    }

    public Object instantiate(Class<?> type) throws ObjectInstantiationException {
        return this.context.instantiate(type);
    }

    public void resolve(Object parent) {
        this.context.resolve(parent);
    }

    public void resolve(Object parent, Object field) {
        this.context.resolve(parent, field);
    }

    public void objectChanged(NakedObject adapter) {
        this.context.objectChanged(adapter.getObject());
    }

    public void objectChanged(Object object) {
        this.context.objectChanged(object);
    }

    public void makePersistent(NakedObject adapter) {
        this.context.makePersistent(adapter.getObject());
    }

    public void remove(NakedObject adapter) {
        this.context.remove(adapter.getObject());
    }

    public boolean flush() {
        return this.context.flush();
    }

    public void commit() {
        this.context.commit();
    }

    public <T> List<NakedObject> allMatchingQuery(Query<T> query) {
        return this.wrap(this.context.allMatchingQuery(query));
    }

    public <T> NakedObject firstMatchingQuery(Query<T> query) {
        return this.adapterFor(this.context.firstMatchingQuery(query));
    }

    private List<NakedObject> wrap(List<?> pojos) {
        ArrayList<NakedObject> adapters = new ArrayList<NakedObject>();
        for (Object pojo : pojos) {
            adapters.add(this.adapterFor(pojo));
        }
        return adapters;
    }

    public void informUser(String message) {
        this.context.informUser(message);
    }

    public void warnUser(String message) {
        this.context.warnUser(message);
    }

    public void raiseError(String message) {
        this.context.raiseError(message);
    }

    public List<NakedObject> getServices() {
        return this.serviceAdapters;
    }

    public void injectDependenciesInto(Object domainObject) {
        if (this.servicesInjector == null) {
            throw new IllegalStateException("must setContainer before using this method");
        }
        this.servicesInjector.injectDependencies(domainObject);
    }

    public ServicesInjector getServicesInjector() {
        return this.servicesInjector;
    }
}

