/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.embedded;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.commons.component.ApplicationScopedComponent;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.IntrospectableSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorAbstract;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutorIdentity;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryDefault;
import org.nakedobjects.metamodel.specloader.progmodelfacets.ProgrammingModelFacets;
import org.nakedobjects.metamodel.specloader.progmodelfacets.ProgrammingModelFacetsJava5;
import org.nakedobjects.metamodel.specloader.traverser.SpecificationTraverser;
import org.nakedobjects.metamodel.specloader.traverser.SpecificationTraverserDefault;
import org.nakedobjects.metamodel.specloader.validator.MetaModelValidator;
import org.nakedobjects.metamodel.specloader.validator.MetaModelValidatorNoop;
import org.nakedobjects.plugins.headless.applib.HeadlessViewer;
import org.nakedobjects.plugins.headless.embedded.EmbeddedContext;
import org.nakedobjects.plugins.headless.embedded.internal.RuntimeContextForEmbeddedMetaModel;
import org.nakedobjects.plugins.headless.viewer.DomainObjectContainerHeadlessViewer;
import org.nakedobjects.plugins.headless.viewer.internal.HeadlessViewerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedObjectsMetaModel
implements ApplicationScopedComponent {
    private final List<Class<?>> serviceTypes = new ArrayList();
    private State state = State.NOT_INITIALIZED;
    private NakedObjectReflectorAbstract reflector;
    private RuntimeContextForEmbeddedMetaModel runtimeContext;
    private NakedObjectConfiguration configuration;
    private ClassSubstitutor classSubstitutor;
    private CollectionTypeRegistry collectionTypeRegistry;
    private ProgrammingModelFacets programmingModelFacets;
    private SpecificationTraverser specificationTraverser;
    private Set<FacetDecorator> facetDecorators;
    private MetaModelValidator metaModelValidator;
    private HeadlessViewer viewer;
    private EmbeddedContext context;
    private List<Object> services;

    public NakedObjectsMetaModel(EmbeddedContext context, Class<?> ... serviceTypes) {
        this.serviceTypes.addAll(Arrays.asList(serviceTypes));
        this.setConfiguration((NakedObjectConfiguration)new PropertiesConfiguration());
        this.setClassSubstitutor((ClassSubstitutor)new ClassSubstitutorIdentity());
        this.setCollectionTypeRegistry((CollectionTypeRegistry)new CollectionTypeRegistryDefault());
        this.setSpecificationTraverser((SpecificationTraverser)new SpecificationTraverserDefault());
        this.setFacetDecorators(new TreeSet<FacetDecorator>());
        this.setProgrammingModelFacets((ProgrammingModelFacets)new ProgrammingModelFacetsJava5());
        this.setMetaModelValidator((MetaModelValidator)new MetaModelValidatorNoop());
        this.context = context;
    }

    public List<Class<?>> getServiceTypes() {
        return Collections.unmodifiableList(this.serviceTypes);
    }

    public void init() {
        this.ensureNotInitialized();
        this.reflector = new NakedObjectReflectorAbstract(this.configuration, this.classSubstitutor, this.collectionTypeRegistry, this.specificationTraverser, this.programmingModelFacets, this.facetDecorators, this.metaModelValidator){};
        this.services = this.createServices(this.serviceTypes);
        this.runtimeContext = new RuntimeContextForEmbeddedMetaModel(this.context, this.services);
        DomainObjectContainerHeadlessViewer container = new DomainObjectContainerHeadlessViewer();
        this.runtimeContext.injectInto(container);
        this.runtimeContext.setContainer((DomainObjectContainer)container);
        this.runtimeContext.injectInto(this.reflector);
        this.reflector.injectInto((Object)this.runtimeContext);
        this.reflector.init();
        this.runtimeContext.init();
        for (Class<?> serviceType : this.serviceTypes) {
            NakedObjectSpecification serviceNoSpec = this.reflector.loadSpecification(serviceType);
            if (!(serviceNoSpec instanceof IntrospectableSpecification)) continue;
            IntrospectableSpecification introspectableSpecification = (IntrospectableSpecification)serviceNoSpec;
            introspectableSpecification.markAsService();
        }
        this.state = State.INITIALIZED;
        this.viewer = new HeadlessViewerImpl((RuntimeContext)this.runtimeContext);
    }

    public void shutdown() {
        this.ensureInitialized();
        this.state = State.SHUTDOWN;
    }

    private List<Object> createServices(List<Class<?>> serviceTypes) {
        ArrayList<Object> services = new ArrayList<Object>();
        for (Class<?> serviceType : serviceTypes) {
            try {
                services.add(serviceType.newInstance());
            }
            catch (InstantiationException e) {
                throw new NakedObjectException("Unable to instantiate service", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NakedObjectException("Unable to instantiate service", (Throwable)e);
            }
        }
        return services;
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.reflector;
    }

    public HeadlessViewer getViewer() {
        this.ensureInitialized();
        return this.viewer;
    }

    public ServicesInjector getServicesInjector() {
        this.ensureInitialized();
        return this.runtimeContext.getServicesInjector();
    }

    public NakedObjectConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NakedObjectConfiguration configuration) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
    }

    public ClassSubstitutor getClassSubstitutor() {
        return this.classSubstitutor;
    }

    public void setClassSubstitutor(ClassSubstitutor classSubstitutor) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg((Object)classSubstitutor, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.classSubstitutor = classSubstitutor;
    }

    public CollectionTypeRegistry getCollectionTypeRegistry() {
        return this.collectionTypeRegistry;
    }

    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg((Object)collectionTypeRegistry, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.collectionTypeRegistry = collectionTypeRegistry;
    }

    public SpecificationTraverser getSpecificationTraverser() {
        return this.specificationTraverser;
    }

    public void setSpecificationTraverser(SpecificationTraverser specificationTraverser) {
        this.specificationTraverser = specificationTraverser;
    }

    public ProgrammingModelFacets getProgrammingModelFacets() {
        return this.programmingModelFacets;
    }

    public void setProgrammingModelFacets(ProgrammingModelFacets programmingModelFacets) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg((Object)programmingModelFacets, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.programmingModelFacets = programmingModelFacets;
    }

    public Set<FacetDecorator> getFacetDecorators() {
        return Collections.unmodifiableSet(this.facetDecorators);
    }

    public void setFacetDecorators(Set<FacetDecorator> facetDecorators) {
        this.ensureNotInitialized();
        Ensure.ensureThatArg(facetDecorators, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.facetDecorators = facetDecorators;
    }

    public MetaModelValidator getMetaModelValidator() {
        return this.metaModelValidator;
    }

    public void setMetaModelValidator(MetaModelValidator metaModelValidator) {
        this.metaModelValidator = metaModelValidator;
    }

    private State ensureNotInitialized() {
        return (State)((Object)Ensure.ensureThatState((Object)((Object)this.state), (Matcher)CoreMatchers.is((Object)((Object)State.NOT_INITIALIZED))));
    }

    private State ensureInitialized() {
        return (State)((Object)Ensure.ensureThatState((Object)((Object)this.state), (Matcher)CoreMatchers.is((Object)((Object)State.INITIALIZED))));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NOT_INITIALIZED,
        INITIALIZED,
        SHUTDOWN;

    }
}

