/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.facets.disable.DisableForContextFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisabledFacetAnnotation;
import org.nakedobjects.plugins.headless.applib.DisabledException;
import org.nakedobjects.plugins.headless.junit.AbstractTest;
import org.nakedobjects.plugins.headless.junit.sample.domain.Order;

public class MemberDisabledTest
extends AbstractTest {
    @Test
    public void whenValueDisabledForValueThenThrowsException() {
        this.custJsDO.disableFirstName = "cannot alter";
        try {
            this.custJsVO.setFirstName("Dick");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisableForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"First Name"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"cannot alter"));
        }
    }

    @Test
    public void whenValueDisabledForNullThenThrowsException() {
        this.custJsDO.disableFirstName = "cannot alter";
        try {
            this.custJsVO.setFirstName(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisableForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"First Name"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"cannot alter"));
        }
    }

    @Test
    public void whenAssociationDisabledForReferenceThenThrowsException() {
        this.custJsDO.disableCountryOfBirth = "cannot alter";
        try {
            this.custJsVO.setCountryOfBirth(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisableForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Country Of Birth"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"cannot alter"));
        }
    }

    @Test
    public void whenAssociationDisabledForNullThenThrowsException() {
        this.custJsDO.disableCountryOfBirth = "cannot alter";
        try {
            this.custJsVO.setCountryOfBirth(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisableForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Country Of Birth"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"cannot alter"));
        }
    }

    @Test
    public void whenCollectionDisabledThenAddToThrowsException() {
        List<Order> orders = this.custJsVO.getOrders();
        Order order = orders.get(0);
        try {
            this.custJsVO.addToMoreOrders(order);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisabledFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"More Orders"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Always disabled"));
        }
    }

    @Test
    public void whenCollectionDisabledThenRemovefromThrowsException() {
        this.custJsDO.addToVisitedCountries(this.countryUsaDO);
        this.custJsDO.disableVisitedCountries = "cannot alter";
        try {
            this.custJsVO.removeFromVisitedCountries(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisableForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Visited Countries"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"cannot alter"));
        }
    }

    @Test
    public void whenActionDisabledThenThrowsException() {
        this.custJsDO.disablePlaceOrder = "cannot invoke";
        try {
            this.custJsVO.placeOrder(this.product355DO, 3);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisableForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Place Order"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"cannot invoke"));
        }
    }
}

