/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetAnnotation;
import org.nakedobjects.metamodel.facets.hide.HideForContextFacetViaMethod;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacetViaMethod;
import org.nakedobjects.plugins.headless.applib.HiddenException;
import org.nakedobjects.plugins.headless.junit.AbstractTest;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;

public class MemberHiddenTest
extends AbstractTest {
    @Test
    public void whenValueHiddenImperativelyForValueThenModifyThrowsException() {
        this.custJsDO.hideFirstName = true;
        try {
            this.custJsVO.setFirstName("Dick");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"First Name"));
        }
    }

    @Test
    public void whenValueHiddenImperativelyForNullThenModifyThrowsException() {
        this.custJsDO.hideFirstName = true;
        try {
            this.custJsVO.setFirstName("Dick");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"First Name"));
        }
    }

    @Test
    public void whenValueHiddenImperativelyThenReadThrowsException() {
        this.custJsDO.hideFirstName = true;
        try {
            this.custJsVO.getFirstName();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"First Name"));
        }
    }

    @Test
    public void whenAssociationHiddenImperativelyForValueThenModifyThrowsException() {
        this.custJsDO.hideCountryOfBirth = true;
        try {
            this.custJsVO.setCountryOfBirth(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Country Of Birth"));
        }
    }

    @Test
    public void whenAssociationHiddenImperativelyForNullThenModifyThrowsException() {
        this.custJsDO.hideCountryOfBirth = true;
        try {
            this.custJsVO.setCountryOfBirth(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Country Of Birth"));
        }
    }

    @Test
    public void whenAssociationHiddenImperativelyThenReadThrowsException() {
        this.custJsDO.hideCountryOfBirth = true;
        try {
            this.custJsVO.getCountryOfBirth();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Country Of Birth"));
        }
    }

    @Test
    public void whenIfCollectionHiddenImperativelyThenAddToThrowsException() {
        this.custJsDO.hideVisitedCountries = true;
        try {
            this.custJsVO.addToVisitedCountries(this.countryGbrDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Visited Countries"));
        }
    }

    @Test
    public void whenCollectionHiddenImperativelyThenRemoveFromThrowsException() {
        this.custJsDO.hideVisitedCountries = true;
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        try {
            this.custJsVO.removeFromVisitedCountries(this.countryGbrDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Visited Countries"));
        }
    }

    @Test
    public void whenCollectionHiddenImperativelyThenReadThrowsException() {
        this.custJsDO.hideVisitedCountries = true;
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        try {
            this.custJsVO.getVisitedCountries();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Visited Countries"));
        }
    }

    @Test
    public void whenActionHiddenImperativelyThenThrowsException() {
        this.custJsDO.hidePlaceOrder = true;
        try {
            this.custJsVO.placeOrder(this.product355DO, 3);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForContextFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Place Order"));
        }
    }

    @Test
    public void whenValueHiddenDeclarativelyForValueThenModifyThrowsException() {
        try {
            this.custJsVO.setAlwaysHiddenValue("Dick");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Value"));
        }
    }

    @Test
    public void whenValueHiddenDeclarativelyForNullThenModifyThrowsException() {
        try {
            this.custJsVO.setAlwaysHiddenValue(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Value"));
        }
    }

    @Test
    public void whenValueHiddenDeclarativelyThenReadThrowsException() {
        try {
            this.custJsVO.getAlwaysHiddenValue();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Value"));
        }
    }

    @Test
    public void whenAssociationHiddenDeclarativelyThenModifyThrowsException() {
        Country[] values;
        for (Country value : values = new Country[]{this.countryUsaDO, null}) {
            try {
                this.custJsVO.setAlwaysHiddenAssociation(value);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (HiddenException ex) {
                Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
                Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Association"));
            }
        }
    }

    @Test
    public void whenAssociationHiddenDeclarativelyThenReadThrowsException() {
        try {
            this.custJsVO.getAlwaysHiddenAssociation();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Association"));
        }
    }

    @Test
    public void whenCollectionHiddenDeclarativelyThenAddToThrowsException() {
        try {
            this.custJsVO.addToAlwaysHiddenCollection(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Collection"));
        }
    }

    @Test
    public void whenCollectionHiddenDeclarativelyThenRemoveFromThrowsException() {
        this.custJsDO.removeFromAlwaysHiddenCollection(this.countryUsaDO);
        try {
            this.custJsVO.removeFromAlwaysHiddenCollection(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Collection"));
        }
    }

    @Test
    public void whenCollectionHiddenDeclarativelyThenReadThrowsException() {
        try {
            this.custJsVO.getAlwaysHiddenCollection();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Collection"));
        }
    }

    @Test
    public void whenActionHiddenDeclarativelyThenThrowsException() {
        try {
            this.custJsVO.alwaysHiddenAction();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HiddenFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Always Hidden Action"));
        }
    }

    @Test
    public void whenValueHiddenNotAuthorizedThenModifyThrowsException() {
        String[] values;
        for (String value : values = new String[]{"Dick", null}) {
            try {
                this.custJsVO.setSessionHiddenValue(value);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (HiddenException ex) {
                Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
                Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Value"));
            }
        }
    }

    @Test
    public void whenValueHiddenNotAuthorizedThenReadThrowsException() {
        try {
            this.custJsVO.getSessionHiddenValue();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Value"));
        }
    }

    @Test
    public void whenAssociationHiddenNotAuthorizedThenModifyThrowsException() {
        Country[] values;
        for (Country value : values = new Country[]{this.countryUsaDO, null}) {
            try {
                this.custJsVO.setSessionHiddenAssociation(value);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (HiddenException ex) {
                Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
                Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Association"));
            }
        }
    }

    @Test
    public void whenAssociationHiddenNotAuthorizedThenReadThrowsException() {
        try {
            this.custJsVO.getSessionHiddenAssociation();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Association"));
        }
    }

    @Test
    public void whenCollectionHiddenNotAuthorizedThenAddToThrowsException() {
        try {
            this.custJsVO.addToSessionHiddenCollection(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Collection"));
        }
    }

    @Test
    public void whenCollectionHiddenNotAuthorizedThenRemoveFromThrowsException() {
        this.custJsDO.addToSessionHiddenCollection(this.countryUsaDO);
        try {
            this.custJsVO.removeFromSessionHiddenCollection(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Collection"));
        }
    }

    @Test
    public void whenCollectionHiddenNotAuthorizedThenReadThrowsException() {
        try {
            this.custJsVO.getSessionHiddenCollection();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Collection"));
        }
    }

    @Test
    public void whenActionHiddenNotAuthorizedThenThrowsException() {
        try {
            this.custJsVO.sessionHiddenAction();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (HiddenException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(HideForSessionFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Session Hidden Action"));
        }
    }
}

