/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.facets.actions.validate.ActionValidationFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateAddToFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacetViaMethod;
import org.nakedobjects.metamodel.facets.properties.validate.PropertyValidateFacetViaMethod;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.MandatoryFacetDefault;
import org.nakedobjects.metamodel.facets.propparam.validate.maxlength.MaxLengthFacetAnnotation;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.RegExFacetAnnotation;
import org.nakedobjects.plugins.headless.applib.InvalidException;
import org.nakedobjects.plugins.headless.junit.AbstractTest;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;

public class MemberInvalidTest
extends AbstractTest {
    @Test
    public void whenValueInvalidImperativelyThenThrowsException() {
        String[] values;
        String[] arr$ = values = new String[]{"Dick", null};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String value;
            this.custJsDO.validateFirstNameExpectedArg = value = arr$[i$];
            this.custJsDO.validateFirstName = "bad first name";
            try {
                this.custJsVO.setFirstName(value);
                Assert.fail((String)"Should have thrown exception");
                continue;
            }
            catch (InvalidException ex) {
                Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(PropertyValidateFacetViaMethod.class));
                Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"First Name"));
                Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"bad first name"));
            }
        }
    }

    @Test
    public void whenAssociationInvalidImperativelyThenThrowsException() {
        Country[] values;
        this.custJsDO.validateCountryOfBirth = "bad country of birth";
        for (Country value : values = new Country[]{this.countryUsaDO, null}) {
            try {
                this.custJsVO.setCountryOfBirth(value);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (InvalidException ex) {
                Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(PropertyValidateFacetViaMethod.class));
                Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Country Of Birth"));
                Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"bad country of birth"));
            }
        }
    }

    @Test
    public void whenCollectionInvalidImperativelyThenAddToThrowsException() {
        this.custJsDO.validateAddToVisitedCountries = "bad country";
        try {
            this.custJsVO.addToVisitedCountries(this.countryGbrDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(CollectionValidateAddToFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Visited Countries"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"bad country"));
        }
    }

    @Test
    public void whenCollectionInvalidImperativelyThenRemoveFromThrowsException() {
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        this.custJsDO.validateRemoveFromVisitedCountries = "bad country";
        try {
            this.custJsVO.removeFromVisitedCountries(this.countryGbrDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(CollectionValidateRemoveFromFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Visited Countries"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"bad country"));
        }
    }

    @Test
    public void whenActionInvalidImperativelyThenThrowsException() {
        this.custJsDO.validatePlaceOrder = "can't place order";
        try {
            this.custJsVO.placeOrder(this.product355DO, 3);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(ActionValidationFacetViaMethod.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Place Order"));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"can't place order"));
        }
    }

    @Test
    public void whenValueCanSetNullOnOptionalField() {
        this.custJsVO.setOptionalValue(null);
    }

    @Test
    public void whenAssociationCanSetNullOnOptionalField() {
        this.custJsVO.setOptionalAssociation(null);
    }

    @Test
    public void whenValueInvalidMandatoryThenThrowsException() {
        try {
            this.custJsVO.setMandatoryValue(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(MandatoryFacetDefault.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Mandatory Value"));
        }
    }

    @Test
    public void whenAssociationInvalidMandatoryThenThrowsException() {
        try {
            this.custJsVO.setMandatoryAssociation(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(MandatoryFacetDefault.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Mandatory Association"));
        }
    }

    @Test
    public void whenInvalidMaxLengthThenThrowsException() {
        try {
            this.custJsVO.setMaxLengthField("This is far too long");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(MaxLengthFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Max Length Field"));
        }
    }

    @Test
    public void whenInvalidRegExCaseSensitiveThenThrowsException() {
        try {
            this.custJsVO.setRegExCaseSensitiveField("abCfoobar");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Reg Ex Case Sensitive Field"));
        }
    }

    @Test
    public void whenCanSetValidRegExCaseSensitive() {
        this.custJsVO.setRegExCaseInsensitiveField("abcfoobar");
    }

    @Test
    public void whenInvalidRegExCaseInsensitiveThenThrowsException() {
        try {
            this.custJsVO.setRegExCaseInsensitiveField("abXfoobar");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(RegExFacetAnnotation.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Reg Ex Case Insensitive Field"));
        }
    }

    @Test
    public void whenCanSetValidRegExCaseInsensitive() {
        this.custJsVO.setRegExCaseInsensitiveField("AbCfoobar");
    }
}

