/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.plugins.headless.applib.InvalidException;
import org.nakedobjects.plugins.headless.junit.AbstractTest;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;
import org.nakedobjects.plugins.headless.junit.sample.domain.Order;

public class MemberModifyTest
extends AbstractTest {
    @Test
    public void valueModifiedToNonNull() {
        this.custJsVO.setFirstName("Dick");
        Assert.assertThat((Object)this.custJsVO.getFirstName(), (Matcher)CoreMatchers.equalTo((Object)"Dick"));
    }

    @Test
    public void valueModifiedToNull() {
        this.custJsVO.setFirstName(null);
        Assert.assertThat((Object)this.custJsVO.getFirstName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void whenValueModifyCalledRatherThanSetForNonNull() {
        this.custJsVO.setFirstName("Dick");
        Assert.assertThat((Object)this.custJsDO.modifyFirstNameCalled, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenValueClearCalledRatherThanSetForNull() {
        this.custJsVO.setFirstName(null);
        Assert.assertThat((Object)this.custJsDO.clearFirstNameCalled, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenAssociationModifyCalledRatherThanSetForNonNull() {
        this.custJsVO.setCountryOfBirth(this.countryUsaDO);
        Assert.assertThat((Object)this.custJsDO.modifyCountryOfBirthCalled, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenAssociationClearCalledRatherThanSetForNull() {
        this.custJsVO.setCountryOfBirth(null);
        Assert.assertThat((Object)this.custJsDO.clearCountryOfBirthCalled, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void cannotUseAddDirectlyOnCollections() {
        List<Country> visitedCountries = this.custJsVO.getVisitedCountries();
        try {
            visitedCountries.add(this.countryGbrDO);
            Assert.fail((String)"UnsupportedOperationException should have been thrown.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void cannotUseRemoveDirectlyOnCollections() {
        List<Country> visitedCountries = this.custJsVO.getVisitedCountries();
        try {
            visitedCountries.remove((Object)this.countryGbrDO);
            Assert.fail((String)"UnsupportedOperationException should have been thrown.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void cannotUseClearDirectlyOnCollections() {
        List<Country> visitedCountries = this.custJsVO.getVisitedCountries();
        try {
            visitedCountries.clear();
            Assert.fail((String)"UnsupportedOperationException should have been thrown.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void sttemptingToAddNullObjectIntoCollectionThrowsException() {
        try {
            this.custJsVO.addToVisitedCountries(null);
            Assert.fail((String)"Exception should have been raised.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void removingNonExistentRemoveObjectFromCollectionDoesNothing() {
        Assert.assertThat((Object)this.custJsDO.getVisitedCountries().contains((Object)this.countryGbrDO), (Matcher)CoreMatchers.is((Object)false));
        this.custJsVO.removeFromVisitedCountries(this.countryGbrDO);
    }

    @Test
    public void canInvokeAction() {
        int sizeBefore = this.custJsVO.getOrders().size();
        Order orderBefore = this.custJsVO.getLastOrder();
        this.custJsVO.placeOrder(this.product355DO, 3);
        Order orderAfter = this.custJsVO.getLastOrder();
        int sizeAfter = this.custJsVO.getOrders().size();
        Assert.assertThat((Object)sizeAfter, (Matcher)CoreMatchers.is((Object)(sizeBefore + 1)));
        Assert.assertThat((Object)((Object)orderAfter), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)((Object)orderBefore))));
    }

    @Test
    public void canInvokeActionIfOptionalValueParameterAndNullArgumentProvided() {
        this.custJsVO.actionWithOptionalValueParameter(null);
        Assert.assertThat((Object)this.custJsDO.actionWithOptionalValueParameterArgument, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void cannotInvokeActionIfMandatoryValueParameterAndNullArgumentProvided() {
        try {
            this.custJsVO.actionWithMandatoryValueParameter(null);
            Assert.fail((String)"InvalidMandatoryException should have been thrown");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)this.custJsDO.actionWithMandatoryValueParameterArgument, (Matcher)CoreMatchers.equalTo((Object)Long.MAX_VALUE));
        }
    }

    @Test
    public void canInvokeActionIfOptionalReferenceParameterAndNullArgumentProvided() {
        this.custJsVO.actionWithOptionalReferenceParameter(null);
        Assert.assertThat((Object)((Object)this.custJsDO.actionWithOptionalReferenceParameterArgument), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void cannotInvokeActionIfMandatoryReferenceParameterAndNullArgumentProvided() {
        try {
            this.custJsVO.actionWithMandatoryReferenceParameter(null);
            Assert.fail((String)"InvalidMandatoryException should have been thrown");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)((Object)this.custJsDO.actionWithMandatoryReferenceParameterArgument), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void canInvokeActionIfOptionalStringParameterAndEmptyStringProvidedAsArgument() {
        this.custJsVO.actionWithOptionalStringParameter("");
        Assert.assertThat((Object)this.custJsDO.actionWithOptionalStringParameterArgument, (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void cannotInvokeActionIfMandatoryStringParameterAndEmptyStringProvidedAsArgument() {
        try {
            this.custJsVO.actionWithMandatoryStringParameter("");
            Assert.fail((String)"InvalidMandatoryException should have been thrown");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)this.custJsDO.actionWithMandatoryStringParameterArgument, (Matcher)CoreMatchers.equalTo((Object)"original value"));
        }
    }

    @Test
    public void canInvokeActionIfParameterMatchRegularExpression() {
        this.custJsVO.actionWithRegExStringParameter("6789");
        Assert.assertThat((Object)this.custJsDO.actionWithRegExStringParameterArgument, (Matcher)CoreMatchers.equalTo((Object)"6789"));
    }

    @Test
    public void cannotInvokeActionIfParameterDoesNotMatchRegularExpression() {
        try {
            this.custJsVO.actionWithRegExStringParameter("abcd");
            Assert.fail((String)"InvalidRegExException should have been thrown");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)this.custJsDO.actionWithRegExStringParameterArgument, (Matcher)CoreMatchers.equalTo((Object)"1234"));
        }
    }

    @Test
    public void canInvokeActionIfParameterNoLongerMaximumLength() {
        this.custJsVO.actionWithMaxLengthStringParameter("abcd");
        Assert.assertThat((Object)this.custJsDO.actionWithMaxLengthStringParameterArgument, (Matcher)CoreMatchers.equalTo((Object)"abcd"));
    }

    @Test
    public void cannotInvokeActionIfParameterExceedsMaximumLength() {
        try {
            this.custJsVO.actionWithMaxLengthStringParameter("abcde");
            Assert.fail((String)"InvalidMaxLengthException should have been thrown");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)this.custJsDO.actionWithMaxLengthStringParameterArgument, (Matcher)CoreMatchers.equalTo((Object)"1234"));
        }
    }
}

