/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.plugins.headless.junit.AbstractTest;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;

public class MemberReadTest
extends AbstractTest {
    @Test
    public void value() {
        Assert.assertThat((Object)this.custJsVO.getFirstName(), (Matcher)CoreMatchers.equalTo((Object)"Richard"));
    }

    @Test
    public void valueWhenNull() {
        this.custJsDO.setFirstName(null);
        Assert.assertThat((Object)this.custJsVO.getFirstName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void association() {
        Assert.assertThat((Object)((Object)this.custJsVO.getCountryOfBirth()), (Matcher)CoreMatchers.equalTo((Object)((Object)this.countryGbrDO)));
    }

    @Test
    public void associationWhenNull() {
        this.custJsDO.setCountryOfBirth(null);
        Assert.assertThat((Object)((Object)this.custJsVO.getCountryOfBirth()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void collectionContainsWhenDoesAndDoesNot() {
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        this.custJsDO.addToVisitedCountries(this.countryUsaDO);
        List<Country> visitedCountries = this.custJsVO.getVisitedCountries();
        Assert.assertThat((Object)visitedCountries.contains((Object)this.countryGbrDO), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)visitedCountries.contains((Object)this.countryUsaDO), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)visitedCountries.contains((Object)this.countryAusDO), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void collectionSizeWhenEmpty() {
        Assert.assertThat((Object)this.custJsVO.getVisitedCountries().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void collectionSizeWhenNotEmpty() {
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        this.custJsDO.addToVisitedCountries(this.countryUsaDO);
        Assert.assertThat((Object)this.custJsVO.getVisitedCountries().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void isEmptySizeWhenEmpty() {
        Assert.assertThat((Object)this.custJsVO.getVisitedCountries().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isEmptySizeWhenNotEmpty() {
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        this.custJsDO.addToVisitedCountries(this.countryUsaDO);
        Assert.assertThat((Object)this.custJsVO.getVisitedCountries().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
    }
}

