/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.facets.object.immutable.DisabledFacetDerivedFromImmutable;
import org.nakedobjects.plugins.headless.applib.DisabledException;
import org.nakedobjects.plugins.headless.junit.AbstractTest;

public class ObjectImmutableTest
extends AbstractTest {
    @Test
    public void settingValueOnImmutableObjectThrowsException() {
        try {
            this.product355VO.setDescription("Changed");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisabledFacetDerivedFromImmutable.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Description"));
        }
    }

    @Test
    public void settingAssociationOnImmutableObjectThrowsException() {
        try {
            this.product355VO.setPlaceOfManufacture(this.countryUsaDO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisabledFacetDerivedFromImmutable.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Place Of Manufacture"));
        }
    }

    @Test
    public void addingToCollectionOnImmutableObjectThrowsException() {
        try {
            this.product355VO.addToSimilarProducts(this.product850DO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisabledFacetDerivedFromImmutable.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Similar Products"));
        }
    }

    @Test
    public void removingFromCollectionOnImmutableObjectThrowsException() {
        this.product355DO.addToSimilarProducts(this.product850DO);
        try {
            this.product355VO.removeFromSimilarProducts(this.product850DO);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (DisabledException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(DisabledFacetDerivedFromImmutable.class));
            Assert.assertThat((Object)ex.getIdentifier().getMemberNaturalName(), (Matcher)CoreMatchers.equalTo((Object)"Similar Products"));
        }
    }

    @Test
    public void canInvokingOnImmutableObject() {
        this.product355VO.foobar();
    }
}

