/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.facets.object.validate.ValidateObjectFacetViaValidateMethod;
import org.nakedobjects.plugins.headless.applib.InvalidException;
import org.nakedobjects.plugins.headless.applib.ViewObject;
import org.nakedobjects.plugins.headless.junit.AbstractTest;
import org.nakedobjects.plugins.headless.junit.sample.domain.Customer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveObjectsTest
extends AbstractTest {
    private ViewObject<Customer> asViewObject(Customer proxiedNewCustomer) {
        return (ViewObject)proxiedNewCustomer;
    }

    @Test
    public void invokingSaveThroughProxyMakesTransientObjectPersistent() {
        Customer newCustomer = (Customer)((Object)this.getDomainObjectContainer().newTransientInstance(Customer.class));
        Assert.assertThat((Object)this.getDomainObjectContainer().isPersistent((Object)newCustomer), (Matcher)CoreMatchers.is((Object)false));
        Customer newCustomerViewObject = (Customer)((Object)this.getHeadlessViewer().view((Object)newCustomer));
        newCustomerViewObject.setCustomerNumber(123);
        newCustomerViewObject.setLastName("Smith");
        newCustomerViewObject.setMandatoryAssociation(this.countryGbrDO);
        newCustomerViewObject.setMandatoryValue("foo");
        newCustomerViewObject.setMaxLengthField("abc");
        newCustomerViewObject.setRegExCaseInsensitiveField("ABCd");
        newCustomerViewObject.setRegExCaseSensitiveField("abcd");
        ViewObject<Customer> proxyNewCustomer = this.asViewObject(newCustomerViewObject);
        proxyNewCustomer.save();
        Assert.assertThat((Object)this.getDomainObjectContainer().isPersistent((Object)newCustomer), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void invokingSaveOnThroughProxyOnAlreadyPersistedObjectJustUpdatesIt() {
        this.custJsDO.setCustomerNumber(123);
        this.custJsDO.setLastName("Smith");
        this.custJsDO.setMandatoryAssociation(this.countryGbrDO);
        this.custJsDO.setMandatoryValue("foo");
        this.custJsDO.setMaxLengthField("abc");
        this.custJsDO.setRegExCaseInsensitiveField("ABCd");
        this.custJsDO.setRegExCaseSensitiveField("abcd");
        Assert.assertThat((Object)this.getDomainObjectContainer().isPersistent((Object)this.custJsDO), (Matcher)CoreMatchers.is((Object)true));
        ViewObject<Customer> proxyNewCustomer = this.asViewObject(this.custJsVO);
        proxyNewCustomer.save();
        Assert.assertThat((Object)this.getDomainObjectContainer().isPersistent((Object)this.custJsDO), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenValidateMethodThenCanVetoSave() {
        Customer newCustomer = (Customer)((Object)this.getDomainObjectContainer().newTransientInstance(Customer.class));
        newCustomer.setCustomerNumber(123);
        newCustomer.setLastName("Smith");
        newCustomer.setMandatoryAssociation(this.countryGbrDO);
        newCustomer.setMandatoryValue("foo");
        newCustomer.setMaxLengthField("abc");
        newCustomer.setRegExCaseInsensitiveField("ABCd");
        newCustomer.setRegExCaseSensitiveField("abcd");
        Customer newCustomerViewObject = (Customer)((Object)this.getHeadlessViewer().view((Object)newCustomer));
        newCustomer.validate = "No shakes";
        ViewObject<Customer> proxyNewCustomer = this.asViewObject(newCustomerViewObject);
        try {
            Assert.assertThat((Object)this.getDomainObjectContainer().isPersistent((Object)newCustomer), (Matcher)CoreMatchers.is((Object)false));
            proxyNewCustomer.save();
            Assert.fail((String)"An InvalidImperativelyException should have been thrown");
        }
        catch (InvalidException ex) {
            Assert.assertThat((Object)ex.getAdvisorClass(), (Matcher)NofMatchers.classEqualTo(ValidateObjectFacetViaValidateMethod.class));
            Assert.assertThat((Object)this.getDomainObjectContainer().isPersistent((Object)newCustomer), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"No shakes"));
        }
    }
}

