/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.plugins.headless.applib.ViewObject;
import org.nakedobjects.plugins.headless.junit.AbstractTest;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;
import org.nakedobjects.plugins.headless.junit.sample.domain.Customer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewObjectTest
extends AbstractTest {
    private ViewObject<Customer> asViewObject() {
        return (ViewObject)this.custJsVO;
    }

    @Test
    public void canCastViewsToViewObject() {
        ViewObject<Customer> custRpVOAsViewObject = this.asViewObject();
    }

    @Test
    public void shouldBeAbleToCreateAView() {
        Customer custRpVO = (Customer)((Object)this.getHeadlessViewer().view((Object)this.custJsDO));
        Assert.assertThat((Object)((Object)custRpVO), (Matcher)CoreMatchers.instanceOf(Customer.class));
        custRpVO.setFirstName("Dick");
        Assert.assertThat((Object)"Dick", (Matcher)CoreMatchers.equalTo((Object)custRpVO.getFirstName()));
    }

    @Test
    public void viewShouldPassesThroughSetterToUnderlyingDomainObject() {
        Customer custRpVO = (Customer)((Object)this.getHeadlessViewer().view((Object)this.custJsDO));
        custRpVO.setFirstName("Dick");
        Assert.assertThat((Object)"Dick", (Matcher)CoreMatchers.equalTo((Object)custRpVO.getFirstName()));
    }

    @Test
    public void objectIsViewShouldReturnTrueWhenDealingWithView() {
        Customer custRpVO = (Customer)((Object)this.getHeadlessViewer().view((Object)this.custJsDO));
        Assert.assertThat((Object)this.getHeadlessViewer().isView((Object)custRpVO), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void objectIsViewShouldReturnFalseWhenDealingWithUnderlying() {
        Assert.assertThat((Object)this.getHeadlessViewer().isView((Object)this.custJsDO), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void collectionInstanceOfViewObjectShouldReturnTrueWhenDealingWithView() {
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        this.custJsDO.addToVisitedCountries(this.countryUsaDO);
        List<Country> visitedCountries = this.custJsVO.getVisitedCountries();
        Assert.assertThat((Object)(visitedCountries instanceof ViewObject), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void containsOnViewedCollectionShouldIntercept() {
        this.custJsDO.addToVisitedCountries(this.countryGbrDO);
        this.custJsDO.addToVisitedCountries(this.countryUsaDO);
        List<Country> visitedCountries = this.custJsVO.getVisitedCountries();
        Assert.assertThat((Object)visitedCountries.contains((Object)this.countryGbrDO), (Matcher)CoreMatchers.is((Object)true));
    }
}

