/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit.sample.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nakedobjects.applib.AbstractDomainObject;
import org.nakedobjects.applib.annotation.DescribedAs;
import org.nakedobjects.applib.annotation.Disabled;
import org.nakedobjects.applib.annotation.Hidden;
import org.nakedobjects.applib.annotation.MaxLength;
import org.nakedobjects.applib.annotation.Named;
import org.nakedobjects.applib.annotation.Optional;
import org.nakedobjects.applib.annotation.RegEx;
import org.nakedobjects.applib.annotation.TypicalLength;
import org.nakedobjects.applib.annotation.When;
import org.nakedobjects.applib.clock.Clock;
import org.nakedobjects.applib.security.UserMemento;
import org.nakedobjects.applib.util.TitleBuffer;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;
import org.nakedobjects.plugins.headless.junit.sample.domain.Order;
import org.nakedobjects.plugins.headless.junit.sample.domain.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer
extends AbstractDomainObject {
    private String firstName;
    public boolean modifyFirstNameCalled = false;
    public boolean clearFirstNameCalled = false;
    public String validateFirstName;
    public String validateFirstNameExpectedArg;
    public String disableFirstName;
    public boolean hideFirstName;
    private Country countryOfBirth;
    public boolean modifyCountryOfBirthCalled = false;
    public boolean clearCountryOfBirthCalled = false;
    public String validateCountryOfBirth;
    public String disableCountryOfBirth;
    public boolean hideCountryOfBirth;
    private List<Country> visitedCountries = new ArrayList<Country>();
    public String validateAddToVisitedCountries;
    public String validateRemoveFromVisitedCountries;
    public String disableVisitedCountries;
    public boolean hideVisitedCountries;
    private String alwaysDisabledValue;
    private Country alwaysDisabledAssociation;
    private List<Country> alwaysDisabledCollection = new ArrayList<Country>();
    private String sessionDisabledValue;
    private Country sessionDisabledAssociation;
    private List<Country> sessionDisabledCollection = new ArrayList<Country>();
    private String alwaysHiddenValue;
    private Country alwaysHiddenAssociation;
    private List<Country> alwaysHiddenCollection = new ArrayList<Country>();
    private String sessionHiddenValue;
    private Country sessionHiddenAssociation;
    private List<Country> sessionHiddenCollection = new ArrayList<Country>();
    private String mandatoryValue;
    private Country mandatoryAssociation;
    private String optionalValue;
    private Country optionalAssociation;
    private List<Country> optionalCollection = new ArrayList<Country>();
    private String maxLengthField;
    private String regExCaseSensitiveField;
    private String regExCaseInsensitiveField;
    private String lastName;
    private Integer customerNumber;
    private List<Order> orders = new ArrayList<Order>();
    private Order lastOrder;
    public String validatePlaceOrder;
    public String disablePlaceOrder;
    public boolean hidePlaceOrder;
    private List<Order> moreOrders = new ArrayList<Order>();
    public String validate;
    public boolean validateCalled = false;
    public Long actionWithOptionalValueParameterArgument = Long.MAX_VALUE;
    public Long actionWithMandatoryValueParameterArgument = Long.MAX_VALUE;
    public Product actionWithMandatoryReferenceParameterArgument = new Product();
    public Product actionWithOptionalReferenceParameterArgument = new Product();
    public String actionWithOptionalStringParameterArgument = "original value";
    public String actionWithMandatoryStringParameterArgument = "original value";
    public String actionWithMaxLengthStringParameterArgument = "1234";
    public String actionWithRegExStringParameterArgument = "1234";

    public String title() {
        TitleBuffer t = new TitleBuffer();
        t.append(this.getFirstName()).append(this.getLastName());
        return t.toString();
    }

    @DescribedAs(value="Given or christian name")
    @TypicalLength(value=20)
    @MaxLength(value=100)
    @Optional
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void modifyFirstName(String firstName) {
        this.setFirstName(firstName);
        this.modifyFirstNameCalled = true;
    }

    public void clearFirstName() {
        this.setFirstName(null);
        this.clearFirstNameCalled = true;
    }

    public String validateFirstName(String firstName) {
        if (this.validateFirstNameExpectedArg != null && !this.validateFirstNameExpectedArg.equals(firstName)) {
            return "argument provided by XAT framework was incorrect";
        }
        return this.validateFirstName;
    }

    public String disableFirstName() {
        return this.disableFirstName;
    }

    public boolean hideFirstName() {
        return this.hideFirstName;
    }

    @Optional
    public Country getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(Country countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    public void modifyCountryOfBirth(Country countryOfBirth) {
        this.setCountryOfBirth(countryOfBirth);
        this.modifyCountryOfBirthCalled = true;
    }

    public void clearCountryOfBirth() {
        this.setCountryOfBirth(null);
        this.clearCountryOfBirthCalled = true;
    }

    public String validateCountryOfBirth(Country countryOfBirth) {
        return this.validateCountryOfBirth;
    }

    public String disableCountryOfBirth() {
        return this.disableCountryOfBirth;
    }

    public boolean hideCountryOfBirth() {
        return this.hideCountryOfBirth;
    }

    public List<Country> getVisitedCountries() {
        return this.visitedCountries;
    }

    private void setVisitedCountries(List<Country> visitedCountries) {
        this.visitedCountries = visitedCountries;
    }

    public void addToVisitedCountries(Country country) {
        this.getVisitedCountries().add(country);
    }

    public void removeFromVisitedCountries(Country country) {
        this.getVisitedCountries().remove((Object)country);
    }

    public String validateAddToVisitedCountries(Country country) {
        return this.validateAddToVisitedCountries;
    }

    public String validateRemoveFromVisitedCountries(Country country) {
        return this.validateRemoveFromVisitedCountries;
    }

    public String disableVisitedCountries() {
        return this.disableVisitedCountries;
    }

    public boolean hideVisitedCountries() {
        return this.hideVisitedCountries;
    }

    @Disabled(value=When.ALWAYS)
    public String getAlwaysDisabledValue() {
        return this.alwaysDisabledValue;
    }

    public void setAlwaysDisabledValue(String alwaysDisabled) {
        this.alwaysDisabledValue = alwaysDisabled;
    }

    @Disabled(value=When.ALWAYS)
    public Country getAlwaysDisabledAssociation() {
        return this.alwaysDisabledAssociation;
    }

    public void setAlwaysDisabledAssociation(Country alwaysDisabled) {
        this.alwaysDisabledAssociation = alwaysDisabled;
    }

    @Disabled(value=When.ALWAYS)
    public List<Country> getAlwaysDisabledCollection() {
        return this.alwaysDisabledCollection;
    }

    private void setAlwaysDisabledCollection(List<Country> alwaysDisabledCollection) {
        this.alwaysDisabledCollection = alwaysDisabledCollection;
    }

    public void addToAlwaysDisabledCollection(Country country) {
        this.getAlwaysDisabledCollection().add(country);
    }

    public void removeFromAlwaysDisabledCollection(Country country) {
        this.getAlwaysDisabledCollection().remove((Object)country);
    }

    @Disabled(value=When.ALWAYS)
    public void alwaysDisabledAction() {
    }

    public String getSessionDisabledValue() {
        return this.sessionDisabledValue;
    }

    public void setSessionDisabledValue(String sessionDisabled) {
        this.sessionDisabledValue = sessionDisabled;
    }

    public static String disableSessionDisabledValue(UserMemento user) {
        return "disabled for this user";
    }

    public Country getSessionDisabledAssociation() {
        return this.sessionDisabledAssociation;
    }

    public void setSessionDisabledAssociation(Country sessionDisabled) {
        this.sessionDisabledAssociation = sessionDisabled;
    }

    public static String disableSessionDisabledAssociation(UserMemento user) {
        return "disabled for this user";
    }

    public List<Country> getSessionDisabledCollection() {
        return this.sessionDisabledCollection;
    }

    private void setSessionDisabledCollection(List<Country> sessionDisabledCollection) {
        this.sessionDisabledCollection = sessionDisabledCollection;
    }

    public void addToSessionDisabledCollection(Country country) {
        this.getSessionDisabledCollection().add(country);
    }

    public void removeFromSessionDisabledCollection(Country country) {
        this.getSessionDisabledCollection().remove((Object)country);
    }

    public static String disableSessionDisabledCollection(UserMemento user) {
        return "disabled for this user";
    }

    public void sessionDisabledAction() {
    }

    public static String disableSessionDisabledAction(UserMemento user) {
        return "disabled for this user";
    }

    @Hidden(value=When.ALWAYS)
    public String getAlwaysHiddenValue() {
        return this.alwaysHiddenValue;
    }

    public void setAlwaysHiddenValue(String alwaysHidden) {
        this.alwaysHiddenValue = alwaysHidden;
    }

    @Hidden(value=When.ALWAYS)
    public Country getAlwaysHiddenAssociation() {
        return this.alwaysHiddenAssociation;
    }

    public void setAlwaysHiddenAssociation(Country alwaysHidden) {
        this.alwaysHiddenAssociation = alwaysHidden;
    }

    @Hidden(value=When.ALWAYS)
    public List<Country> getAlwaysHiddenCollection() {
        return this.alwaysHiddenCollection;
    }

    private void setAlwaysHiddenCollection(List<Country> alwaysHiddenCollection) {
        this.alwaysHiddenCollection = alwaysHiddenCollection;
    }

    public void addToAlwaysHiddenCollection(Country country) {
        this.getAlwaysHiddenCollection().add(country);
    }

    public void removeFromAlwaysHiddenCollection(Country country) {
        this.getAlwaysHiddenCollection().remove((Object)country);
    }

    @Hidden(value=When.ALWAYS)
    public void alwaysHiddenAction() {
    }

    public String getSessionHiddenValue() {
        return this.sessionHiddenValue;
    }

    public void setSessionHiddenValue(String sessionHidden) {
        this.sessionHiddenValue = sessionHidden;
    }

    public static boolean hideSessionHiddenValue(UserMemento user) {
        return true;
    }

    public Country getSessionHiddenAssociation() {
        return this.sessionHiddenAssociation;
    }

    public void setSessionHiddenAssociation(Country sessionHidden) {
        this.sessionHiddenAssociation = sessionHidden;
    }

    public static boolean hideSessionHiddenAssociation(UserMemento user) {
        return true;
    }

    public List<Country> getSessionHiddenCollection() {
        return this.sessionHiddenCollection;
    }

    private void setSessionHiddenCollection(List<Country> sessionHiddenCollection) {
        this.sessionHiddenCollection = sessionHiddenCollection;
    }

    public void addToSessionHiddenCollection(Country country) {
        this.getSessionHiddenCollection().add(country);
    }

    public void removeFromSessionHiddenCollection(Country country) {
        this.getSessionHiddenCollection().remove((Object)country);
    }

    public static boolean hideSessionHiddenCollection(UserMemento user) {
        return true;
    }

    public void sessionHiddenAction() {
    }

    public static boolean hideSessionHiddenAction(UserMemento user) {
        return true;
    }

    public String getMandatoryValue() {
        return this.mandatoryValue;
    }

    public void setMandatoryValue(String mandatory) {
        this.mandatoryValue = mandatory;
    }

    public Country getMandatoryAssociation() {
        return this.mandatoryAssociation;
    }

    public void setMandatoryAssociation(Country mandatory) {
        this.mandatoryAssociation = mandatory;
    }

    @Optional
    public String getOptionalValue() {
        return this.optionalValue;
    }

    public void setOptionalValue(String optional) {
        this.optionalValue = optional;
    }

    @Optional
    public Country getOptionalAssociation() {
        return this.optionalAssociation;
    }

    public void setOptionalAssociation(Country optional) {
        this.optionalAssociation = optional;
    }

    @Optional
    public List<Country> getOptionalCollection() {
        return this.optionalCollection;
    }

    private void setOptionalCollection(List<Country> optionalCollection) {
        this.optionalCollection = optionalCollection;
    }

    public void addToOptionalCollection(Country country) {
        this.getOptionalCollection().add(country);
    }

    public void removeFromOptionalCollection(Country country) {
        this.getOptionalCollection().remove((Object)country);
    }

    @MaxLength(value=10)
    public String getMaxLengthField() {
        return this.maxLengthField;
    }

    public void setMaxLengthField(String maxLength) {
        this.maxLengthField = maxLength;
    }

    @RegEx(validation="abc.+", caseSensitive=true)
    public String getRegExCaseSensitiveField() {
        return this.regExCaseSensitiveField;
    }

    public void setRegExCaseSensitiveField(String regEx) {
        this.regExCaseSensitiveField = regEx;
    }

    @RegEx(validation="abc.+", caseSensitive=false)
    public String getRegExCaseInsensitiveField() {
        return this.regExCaseInsensitiveField;
    }

    public void setRegExCaseInsensitiveField(String regExCaseInsensitive) {
        this.regExCaseInsensitiveField = regExCaseInsensitive;
    }

    @DescribedAs(value="Family name or surname")
    @MaxLength(value=100)
    @TypicalLength(value=30)
    @Named(value="Surname")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void modifyLastName(String lastName) {
        this.lastName = lastName;
    }

    @Disabled(value=When.ONCE_PERSISTED)
    public Integer getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(Integer customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String validateCustomerNumber(Integer customerNumber) {
        return null;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    private void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public void addToOrders(Order order) {
        this.getOrders().add(order);
    }

    public void removeFromOrders(Order order) {
        this.getOrders().remove((Object)order);
    }

    @Disabled
    public Order getLastOrder() {
        return this.lastOrder;
    }

    public void setLastOrder(Order lastOrder) {
        this.lastOrder = lastOrder;
    }

    public void modifyLastOrder(Order lastOrder) {
        this.setLastOrder(lastOrder);
    }

    public void clearLastOrder() {
        this.setLastOrder(null);
    }

    public void placeOrder(Product p, @Named(value="Quantity") Integer quantity) {
        Order order = (Order)((Object)this.getContainer().newTransientInstance(Order.class));
        order.modifyCustomer(this);
        order.modifyProduct(p);
        order.setOrderDate(new Date(Clock.getTime()));
        order.setQuantity(quantity);
        this.addToOrders(order);
        this.modifyLastOrder(order);
        order.makePersistent();
    }

    public String validatePlaceOrder(Product p, Integer quantity) {
        return this.validatePlaceOrder;
    }

    public String disablePlaceOrder() {
        return this.disablePlaceOrder;
    }

    public boolean hidePlaceOrder() {
        return this.hidePlaceOrder;
    }

    public Object[] defaultPlaceOrder() {
        Product lastProductOrdered = null;
        if (this.getLastOrder() != null) {
            lastProductOrdered = this.getLastOrder().getProduct();
        }
        return new Object[]{lastProductOrdered, new Integer(1)};
    }

    @Disabled
    public List<Order> getMoreOrders() {
        return this.moreOrders;
    }

    private void setMoreOrders(List<Order> moreOrders) {
        this.moreOrders = moreOrders;
    }

    public void addToMoreOrders(Order order) {
        this.getMoreOrders().add(order);
    }

    public void removeFromMoreOrders(Order order) {
        this.getMoreOrders().remove((Object)order);
    }

    public String validate() {
        this.validateCalled = true;
        return this.validate;
    }

    public void actionWithOptionalValueParameter(@Optional @Named(value="Amount") Long val) {
        this.actionWithOptionalValueParameterArgument = val;
    }

    public void actionWithMandatoryValueParameter(@Named(value="Amount") Long val) {
        this.actionWithMandatoryValueParameterArgument = val;
    }

    public void actionWithMandatoryReferenceParameter(Product product) {
        this.actionWithMandatoryReferenceParameterArgument = product;
    }

    public void actionWithOptionalReferenceParameter(@Optional Product product) {
        this.actionWithOptionalReferenceParameterArgument = product;
    }

    public void actionWithOptionalStringParameter(@Optional @Named(value="Amount") String val) {
        this.actionWithOptionalStringParameterArgument = val;
    }

    public void actionWithMandatoryStringParameter(@Named(value="Amount") String val) {
        this.actionWithMandatoryStringParameterArgument = val;
    }

    public void actionWithMaxLengthStringParameter(@Named(value="Amount") @MaxLength(value=4) String val) {
        this.actionWithMaxLengthStringParameterArgument = val;
    }

    public void actionWithRegExStringParameter(@Named(value="Amount") @RegEx(validation="[0-9]{4}") String val) {
        this.actionWithRegExStringParameterArgument = val;
    }
}

