/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit.sample.domain;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.AbstractDomainObject;
import org.nakedobjects.applib.annotation.Disabled;
import org.nakedobjects.applib.annotation.Immutable;
import org.nakedobjects.applib.annotation.MaxLength;
import org.nakedobjects.applib.annotation.Optional;
import org.nakedobjects.applib.annotation.TypicalLength;
import org.nakedobjects.applib.annotation.When;
import org.nakedobjects.applib.util.TitleBuffer;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Product
extends AbstractDomainObject {
    private static final Logger LOGGER = Logger.getLogger(Product.class);
    private String code;
    private String description;
    private Country placeOfManufacture;
    private Double price;
    private List<Product> similarProducts = new ArrayList<Product>();
    public String validateAddToSimilarProducts;
    public String validateRemoveFromSimilarProducts;
    public String disableSimilarProducts;
    public boolean hideSimilarProducts;

    public String title() {
        TitleBuffer t = new TitleBuffer();
        t.append(this.getCode());
        t.append(":", this.getDescription());
        return t.toString();
    }

    @TypicalLength(value=9)
    @MaxLength(value=9)
    @Disabled(value=When.ONCE_PERSISTED)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @TypicalLength(value=50)
    @MaxLength(value=255)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Optional
    public Country getPlaceOfManufacture() {
        return this.placeOfManufacture;
    }

    public void setPlaceOfManufacture(Country placeOfManufacture) {
        this.placeOfManufacture = placeOfManufacture;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public String validatePrice(Double price) {
        if (price <= 0.0) {
            return "Price must be positive";
        }
        return null;
    }

    public List<Product> getSimilarProducts() {
        return this.similarProducts;
    }

    private void setSimilarProducts(List<Product> similarProducts) {
        this.similarProducts = similarProducts;
    }

    public void addToSimilarProducts(Product country) {
        this.getSimilarProducts().add(country);
    }

    public void removeFromSimilarProducts(Product country) {
        this.getSimilarProducts().remove((Object)country);
    }

    public String validateAddToSimilarProducts(Product country) {
        return this.validateAddToSimilarProducts;
    }

    public String validateRemoveFromSimilarProducts(Product country) {
        return this.validateRemoveFromSimilarProducts;
    }

    public String disableSimilarProducts() {
        return this.disableSimilarProducts;
    }

    public boolean hideSimilarProducts() {
        return this.hideSimilarProducts;
    }

    public void foobar() {
    }
}

