/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit.sample.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.AbstractFactoryAndRepository;
import org.nakedobjects.applib.Filter;
import org.nakedobjects.applib.annotation.Hidden;
import org.nakedobjects.applib.annotation.Named;
import org.nakedobjects.plugins.headless.junit.sample.domain.Country;
import org.nakedobjects.plugins.headless.junit.sample.domain.Customer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="Customers")
public class CustomerRepository
extends AbstractFactoryAndRepository {
    private static final Logger LOGGER = Logger.getLogger(CustomerRepository.class);

    public List<Customer> showAll() {
        return this.allInstances(Customer.class);
    }

    public List<Customer> findAllByName(@Named(value="Last name") String lastName) {
        return this.allMatches(Customer.class, new FilterLastName(lastName));
    }

    public Customer findByName(@Named(value="Last name") String lastName) {
        Customer firstMatch = (Customer)((Object)this.firstMatch(Customer.class, new FilterLastName(lastName)));
        return firstMatch;
    }

    public Customer newCustomer() {
        Customer customer = (Customer)((Object)this.newTransientInstance(Customer.class));
        return customer;
    }

    @Hidden
    public Customer newCustomer(String firstName, String lastName, int customerNumber, Country countryOfBirth) {
        Customer customer = this.newCustomer();
        customer.setFirstName(firstName);
        customer.setLastName(lastName);
        customer.setCustomerNumber(customerNumber);
        customer.modifyCountryOfBirth(countryOfBirth);
        this.persist((Object)customer);
        return customer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FilterLastName
    implements Filter<Customer> {
        private final String name;

        private FilterLastName(String name) {
            this.name = name;
        }

        public boolean accept(Customer customer) {
            return customer.getLastName().toLowerCase().contains(this.name.toLowerCase());
        }
    }
}

