/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit.sample.service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.AbstractFactoryAndRepository;
import org.nakedobjects.applib.annotation.Named;
import org.nakedobjects.plugins.headless.junit.sample.domain.Customer;
import org.nakedobjects.plugins.headless.junit.sample.domain.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="Orders")
public class OrderRepository
extends AbstractFactoryAndRepository {
    private static final Logger LOGGER = Logger.getLogger(OrderRepository.class);

    public List<Order> findRecentOrders(Customer customer, @Named(value="Number of Orders") Integer numberOfOrders) {
        List<Order> orders = customer.getOrders();
        Collections.sort(orders, new Comparator<Order>(){

            @Override
            public int compare(Order o1, Order o2) {
                long time1 = o1.getOrderDate().getTime();
                long time2 = o2.getOrderDate().getTime();
                return (int)(time2 - time1);
            }
        });
        if (orders.size() < numberOfOrders) {
            return orders;
        }
        return orders.subList(0, numberOfOrders);
    }

    public Object[] defaultFindRecentOrders(Customer customer, Integer numberOfOrders) {
        return new Object[]{null, new Integer(3)};
    }
}

