/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit.sample.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.AbstractFactoryAndRepository;
import org.nakedobjects.applib.Filter;
import org.nakedobjects.applib.annotation.Hidden;
import org.nakedobjects.applib.annotation.Named;
import org.nakedobjects.plugins.headless.junit.sample.domain.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="Products")
public class ProductRepository
extends AbstractFactoryAndRepository {
    private static final Logger LOGGER = Logger.getLogger(ProductRepository.class);

    public List<Product> showAll() {
        return this.allInstances(Product.class);
    }

    public Product findByCode(final @Named(value="Code") String code) {
        return (Product)((Object)this.firstMatch(Product.class, (Filter)new Filter<Product>(){

            public boolean accept(Product product) {
                return code.equals(product.getCode());
            }
        }));
    }

    @Hidden
    public Product newProduct(String code, String description, int priceInPence) {
        Product product = (Product)((Object)this.newTransientInstance(Product.class));
        product.setCode(code);
        product.setDescription(description);
        product.setPrice(new Double(priceInPence / 100));
        this.persist((Object)product);
        return product;
    }

    @Hidden
    public Product newProduct() {
        return (Product)((Object)this.newTransientInstance(Product.class));
    }
}

