/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.junit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jmock.Mockery;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.JUnit4ClassRunner;
import org.junit.internal.runners.MethodRoadie;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.ConfigurationBuilderDefault;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.plugins.headless.junit.internal.NakedObjectsSystemUsingInstallersWithinJunit;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.authentication.standard.fixture.AuthenticationRequestLogonFixture;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupDefault;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.Splash;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedObjectsTestRunner
extends JUnit4ClassRunner {
    private final Field mockeryField;

    public NakedObjectsTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.mockeryField = NakedObjectsTestRunner.findFieldAndMakeAccessible(testClass, Mockery.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        Description description = this.methodDescription(method);
        ConfigurationBuilderDefault configurationBuilder = new ConfigurationBuilderDefault();
        InstallerLookupDefault installerLookup = new InstallerLookupDefault(((Object)((Object)this)).getClass());
        configurationBuilder.injectInto((Object)installerLookup);
        installerLookup.init();
        NakedObjectsSystemUsingInstallersWithinJunit system = null;
        AuthenticationSession session = null;
        try {
            DeploymentType deploymentType = DeploymentType.PROTOTYPE;
            system = new NakedObjectsSystemUsingInstallersWithinJunit(deploymentType, (InstallerLookup)installerLookup, this.getTestClass());
            system.setSplash(Splash.NO_SHOW);
            system.init();
            LogonFixture logonFixture = system.getFixturesInstaller().getLogonFixture();
            Object request = logonFixture != null ? new AuthenticationRequestLogonFixture(logonFixture) : new AuthenticationRequestExploration(logonFixture);
            session = NakedObjectsContext.getAuthenticationManager().authenticate((AuthenticationRequest)request);
            NakedObjectsContext.openSession((AuthenticationSession)session);
            NakedObjectsTestRunner.getTransactionManager().startTransaction();
            Object test = this.createTest();
            NakedObjectsTestRunner.getServicesInjector().injectDependencies(test);
            TestMethod testMethod = this.wrapMethod(method);
            new MethodRoadie(test, testMethod, notifier, description).run();
            NakedObjectsTestRunner.getTransactionManager().endTransaction();
        }
        catch (InvocationTargetException e) {
            notifier.testAborted(description, e.getCause());
            NakedObjectsTestRunner.getTransactionManager().abortTransaction();
            return;
        }
        catch (Exception e) {
            notifier.testAborted(description, (Throwable)e);
            return;
        }
        finally {
            if (system != null) {
                if (session != null) {
                    NakedObjectsContext.closeSession();
                }
                system.shutdown();
            }
        }
    }

    protected TestMethod wrapMethod(Method method) {
        return new TestMethod(method, this.getTestClass()){

            public void invoke(Object testFixture) throws IllegalAccessException, InvocationTargetException {
                super.invoke(testFixture);
                if (NakedObjectsTestRunner.this.mockeryField != null) {
                    NakedObjectsTestRunner.this.mockeryOf(testFixture).assertIsSatisfied();
                }
            }
        };
    }

    protected Mockery mockeryOf(Object test) {
        if (this.mockeryField == null) {
            return null;
        }
        try {
            Mockery mockery = (Mockery)this.mockeryField.get(test);
            if (mockery == null) {
                throw new IllegalStateException(String.format("Mockery named '%s' is null", this.mockeryField.getName()));
            }
            return mockery;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("cannot get value of field %s", this.mockeryField.getName()), e);
        }
    }

    static Field findFieldAndMakeAccessible(Class<?> testClass, Class<?> clazz) throws InitializationError {
        for (Class<?> c = testClass; c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!clazz.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static ServicesInjector getServicesInjector() {
        return NakedObjectsTestRunner.getPersistenceSession().getServicesInjector();
    }

    private static NakedObjectTransactionManager getTransactionManager() {
        return NakedObjectsTestRunner.getPersistenceSession().getTransactionManager();
    }
}

