/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.viewer.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nakedobjects.applib.events.InteractionEvent;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.headless.applib.HeadlessViewer;
import org.nakedobjects.plugins.headless.viewer.internal.DelegatingInvocationHandler;
import org.nakedobjects.runtime.persistence.container.DomainObjectContainerObjectChanged;
import org.nakedobjects.runtime.persistence.container.DomainObjectContainerResolve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingInvocationHandlerDefault<T>
implements DelegatingInvocationHandler<T> {
    private final T delegate;
    protected final HeadlessViewer headlessViewer;
    private final HeadlessViewer.ExecutionMode executionMode;
    private final RuntimeContext runtimeContext;
    protected final Method equalsMethod;
    protected final Method hashCodeMethod;
    protected final Method toStringMethod;
    private DomainObjectContainerObjectChanged domainObjectContainerObjectChanged;
    private DomainObjectContainerResolve domainObjectContainerResolve;
    private boolean resolveObjectChangedEnabled;

    public DelegatingInvocationHandlerDefault(T delegate, HeadlessViewer headlessViewer, HeadlessViewer.ExecutionMode executionMode, RuntimeContext runtimeContext) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.delegate = delegate;
        this.headlessViewer = headlessViewer;
        this.executionMode = executionMode;
        this.runtimeContext = runtimeContext;
        this.domainObjectContainerResolve = new DomainObjectContainerResolve();
        this.domainObjectContainerObjectChanged = new DomainObjectContainerObjectChanged();
        try {
            this.equalsMethod = delegate.getClass().getMethod("equals", Object.class);
            this.hashCodeMethod = delegate.getClass().getMethod("hashCode", new Class[0]);
            this.toStringMethod = delegate.getClass().getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("An Object method could not be found: " + e.getMessage());
        }
    }

    @Override
    public boolean isResolveObjectChangedEnabled() {
        return this.resolveObjectChangedEnabled;
    }

    @Override
    public void setResolveObjectChangedEnabled(boolean resolveObjectChangedEnabled) {
        this.resolveObjectChangedEnabled = resolveObjectChangedEnabled;
    }

    protected void resolveIfRequired(NakedObject targetAdapter) {
        this.resolveIfRequired(targetAdapter.getObject());
    }

    protected void resolveIfRequired(Object domainObject) {
        if (this.resolveObjectChangedEnabled) {
            this.domainObjectContainerResolve.resolve(domainObject);
        }
    }

    protected void objectChangedIfRequired(NakedObject targetAdapter) {
        this.objectChangedIfRequired(targetAdapter.getObject());
    }

    protected void objectChangedIfRequired(Object domainObject) {
        if (this.resolveObjectChangedEnabled) {
            this.domainObjectContainerObjectChanged.objectChanged(domainObject);
        }
    }

    public HeadlessViewer getHeadlessViewer() {
        return this.headlessViewer;
    }

    @Override
    public T getDelegate() {
        return this.delegate;
    }

    public HeadlessViewer.ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    protected Object delegate(Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return method.invoke(this.getDelegate(), args);
    }

    protected boolean isObjectMethod(Method method) {
        return this.toStringMethod.equals(method) || this.hashCodeMethod.equals(method) || this.equalsMethod.equals(method);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        return method.invoke(object, args);
    }

    protected InteractionEvent notifyListeners(InteractionEvent interactionEvent) {
        this.headlessViewer.notifyListeners(interactionEvent);
        return interactionEvent;
    }

    protected RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.runtimeContext.getSpecificationLoader();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.runtimeContext.getAuthenticationSession();
    }
}

