/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.viewer.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nakedobjects.applib.events.CollectionAccessEvent;
import org.nakedobjects.applib.events.InteractionEvent;
import org.nakedobjects.applib.events.ObjectTitleEvent;
import org.nakedobjects.applib.events.PropertyAccessEvent;
import org.nakedobjects.applib.events.UsabilityEvent;
import org.nakedobjects.applib.events.ValidityEvent;
import org.nakedobjects.applib.events.VisibilityEvent;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.lang.StringUtils;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.interactions.ObjectTitleContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.JavaSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.util.NakedObjectUtils;
import org.nakedobjects.plugins.headless.applib.DisabledException;
import org.nakedobjects.plugins.headless.applib.HeadlessViewer;
import org.nakedobjects.plugins.headless.applib.HiddenException;
import org.nakedobjects.plugins.headless.applib.InteractionException;
import org.nakedobjects.plugins.headless.applib.InvalidException;
import org.nakedobjects.plugins.headless.applib.ViewObject;
import org.nakedobjects.plugins.headless.viewer.internal.DelegatingInvocationHandlerDefault;
import org.nakedobjects.plugins.headless.viewer.internal.Proxy;
import org.nakedobjects.plugins.headless.viewer.internal.util.Constants;
import org.nakedobjects.plugins.headless.viewer.internal.util.MethodPrefixFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainObjectInvocationHandler<T>
extends DelegatingInvocationHandlerDefault<T> {
    protected Method titleMethod;
    protected Method saveMethod;
    protected Method underlyingMethod;
    private final Map<Method, Collection<?>> collectionViewObjectsByMethod = new HashMap();
    private final Map<Method, Map<?, ?>> mapViewObjectsByMethod = new HashMap();

    public DomainObjectInvocationHandler(T delegate, HeadlessViewer embeddedViewer, HeadlessViewer.ExecutionMode mode, RuntimeContext runtimeContext) {
        super(delegate, embeddedViewer, mode, runtimeContext);
        try {
            this.titleMethod = delegate.getClass().getMethod("title", new Class[0]);
            this.saveMethod = ViewObject.class.getMethod("save", new Class[0]);
            this.underlyingMethod = ViewObject.class.getMethod("underlying", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    @Override
    public Object invoke(Object proxyObject, Method method, Object[] args) throws Throwable {
        if (this.isObjectMethod(method)) {
            return this.delegate(method, args);
        }
        NakedObject targetAdapter = this.getRuntimeContext().getAdapterFor(this.getDelegate());
        if (this.isTitleMethod(method)) {
            return this.handleTitleMethod(method, args, targetAdapter);
        }
        NakedObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        if (this.isSaveMethod(method)) {
            return this.handleSaveMethod(this.getAuthenticationSession(), targetAdapter, targetNoSpec);
        }
        if (this.isUnderlyingMethod(method)) {
            return this.getDelegate();
        }
        NakedObjectMember nakedObjectMember = this.locateAndCheckMember(method);
        String memberName = nakedObjectMember.getName();
        String methodName = method.getName();
        String prefix = this.checkPrefix(methodName);
        if (this.isDefaultMethod(prefix) || this.isChoicesMethod(prefix)) {
            return method.invoke(this.getDelegate(), args);
        }
        boolean isGetterMethod = this.isGetterMethod(prefix);
        boolean isSetterMethod = this.isSetterMethod(prefix);
        boolean isAddToMethod = this.isAddToMethod(prefix);
        boolean isRemoveFromMethod = this.isRemoveFromMethod(prefix);
        this.checkVisibility(this.getAuthenticationSession(), targetAdapter, nakedObjectMember);
        if (nakedObjectMember.isOneToOneAssociation()) {
            OneToOneAssociation otoa = (OneToOneAssociation)nakedObjectMember;
            if (isGetterMethod) {
                return this.handleGetterMethodOnProperty(args, targetAdapter, otoa, methodName);
            }
            if (isSetterMethod) {
                this.checkUsability(this.getAuthenticationSession(), targetAdapter, nakedObjectMember);
                return this.handleSetterMethodOnProperty(args, this.getAuthenticationSession(), targetAdapter, otoa, methodName);
            }
        }
        if (nakedObjectMember.isOneToManyAssociation()) {
            OneToManyAssociation otma = (OneToManyAssociation)nakedObjectMember;
            if (isGetterMethod) {
                return this.handleGetterMethodOnCollection(method, args, targetAdapter, otma, memberName);
            }
            if (isAddToMethod) {
                this.checkUsability(this.getAuthenticationSession(), targetAdapter, nakedObjectMember);
                return this.handleCollectionAddToMethod(args, targetAdapter, otma, methodName);
            }
            if (isRemoveFromMethod) {
                this.checkUsability(this.getAuthenticationSession(), targetAdapter, nakedObjectMember);
                return this.handleCollectionRemoveFromMethod(args, targetAdapter, otma, methodName);
            }
        }
        if (isGetterMethod) {
            throw new UnsupportedOperationException(String.format("Can only invoke 'get' on properties or collections; '%s' represents %s", methodName, this.decode(nakedObjectMember)));
        }
        if (isSetterMethod) {
            throw new UnsupportedOperationException(String.format("Can only invoke 'set' on properties; '%s' represents %s", methodName, this.decode(nakedObjectMember)));
        }
        if (isAddToMethod) {
            throw new UnsupportedOperationException(String.format("Can only invoke 'addTo' on collections; '%s' represents %s", methodName, this.decode(nakedObjectMember)));
        }
        if (isRemoveFromMethod) {
            throw new UnsupportedOperationException(String.format("Can only invoke 'removeFrom' on collections; '%s' represents %s", methodName, this.decode(nakedObjectMember)));
        }
        if (nakedObjectMember instanceof NakedObjectAction) {
            this.checkUsability(this.getAuthenticationSession(), targetAdapter, nakedObjectMember);
            NakedObjectAction noa = (NakedObjectAction)nakedObjectMember;
            return this.handleActionMethod(args, this.getAuthenticationSession(), targetAdapter, noa, memberName);
        }
        throw new UnsupportedOperationException(String.format("Unknown member type '%s'", nakedObjectMember));
    }

    private Object handleTitleMethod(Method method, Object[] args, NakedObject targetAdapter) throws IllegalAccessException, InvocationTargetException {
        this.resolveIfRequired(targetAdapter);
        NakedObjectSpecification targetNoSpec = targetAdapter.getSpecification();
        ObjectTitleContext titleContext = targetNoSpec.createTitleInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, targetAdapter);
        ObjectTitleEvent titleEvent = titleContext.createInteractionEvent();
        this.notifyListeners((InteractionEvent)titleEvent);
        return titleEvent.getTitle();
    }

    private Object handleSaveMethod(AuthenticationSession session, NakedObject targetAdapter, NakedObjectSpecification targetNoSpec) {
        InteractionResult interactionResult = targetNoSpec.isValidResult(targetAdapter);
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == HeadlessViewer.ExecutionMode.EXECUTE && targetAdapter.isTransient()) {
            this.getRuntimeContext().makePersistent(targetAdapter);
        }
        return null;
    }

    private Object handleGetterMethodOnProperty(Object[] args, NakedObject targetAdapter, OneToOneAssociation otoa, String methodName) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        this.resolveIfRequired(targetAdapter);
        NakedObject currentReferencedAdapter = otoa.get(targetAdapter);
        Object currentReferencedObj = NakedObjectUtils.unwrap((NakedObject)currentReferencedAdapter);
        PropertyAccessEvent ev = new PropertyAccessEvent(this.getDelegate(), otoa.getIdentifier(), currentReferencedObj);
        this.notifyListeners((InteractionEvent)ev);
        return currentReferencedObj;
    }

    private Object handleSetterMethodOnProperty(Object[] args, AuthenticationSession session, NakedObject targetAdapter, OneToOneAssociation otoa, String methodName) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a setter should only have a single argument");
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        NakedObject argumentNO = argumentObj != null ? this.getRuntimeContext().adapterFor(argumentObj) : null;
        InteractionResult interactionResult = otoa.isAssociationValid(targetAdapter, argumentNO).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == HeadlessViewer.ExecutionMode.EXECUTE) {
            if (argumentNO != null) {
                otoa.setAssociation(targetAdapter, argumentNO);
            } else {
                otoa.clearAssociation(targetAdapter);
            }
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleGetterMethodOnCollection(Method method, Object[] args, NakedObject targetAdapter, OneToManyAssociation otma, String memberName) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invoking a 'get' should have no arguments");
        }
        this.resolveIfRequired(targetAdapter);
        NakedObject currentReferencedAdapter = otma.get(targetAdapter);
        Object currentReferencedObj = NakedObjectUtils.unwrap((NakedObject)currentReferencedAdapter);
        CollectionAccessEvent ev = new CollectionAccessEvent(this.getDelegate(), otma.getIdentifier());
        if (currentReferencedObj instanceof Collection) {
            Collection<?> collectionViewObject = this.lookupViewObject(method, memberName, (Collection)currentReferencedObj, otma);
            this.notifyListeners((InteractionEvent)ev);
            return collectionViewObject;
        }
        if (currentReferencedObj instanceof Map) {
            Map<?, ?> mapViewObject = this.lookupViewObject(method, memberName, (Map)currentReferencedObj, otma);
            this.notifyListeners((InteractionEvent)ev);
            return mapViewObject;
        }
        throw new IllegalArgumentException(String.format("Collection type '%s' not supported by framework", currentReferencedObj.getClass().getName()));
    }

    private Collection<?> lookupViewObject(Method method, String memberName, Collection<?> collectionToLookup, OneToManyAssociation otma) {
        Collection<?> collectionViewObject = this.collectionViewObjectsByMethod.get(method);
        if (collectionViewObject == null) {
            collectionViewObject = collectionToLookup instanceof ViewObject ? collectionToLookup : Proxy.proxy(collectionToLookup, memberName, this, this.getRuntimeContext(), otma);
            this.collectionViewObjectsByMethod.put(method, collectionViewObject);
        }
        return collectionViewObject;
    }

    private Map<?, ?> lookupViewObject(Method method, String memberName, Map<?, ?> mapToLookup, OneToManyAssociation otma) {
        Map<?, ?> mapViewObject = this.mapViewObjectsByMethod.get(method);
        if (mapViewObject == null) {
            mapViewObject = mapToLookup instanceof ViewObject ? mapToLookup : Proxy.proxy(mapToLookup, memberName, this, this.getRuntimeContext(), otma);
            this.mapViewObjectsByMethod.put(method, mapViewObject);
        }
        return mapViewObject;
    }

    private Object handleCollectionAddToMethod(Object[] args, NakedObject targetAdapter, OneToManyAssociation otma, String methodName) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a addTo should only have a single argument");
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to add");
        }
        NakedObject argumentNO = this.getRuntimeContext().adapterFor(argumentObj);
        InteractionResult interactionResult = otma.isValidToAdd(targetAdapter, argumentNO).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == HeadlessViewer.ExecutionMode.EXECUTE) {
            otma.addElement(targetAdapter, argumentNO);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleCollectionRemoveFromMethod(Object[] args, NakedObject targetAdapter, OneToManyAssociation otma, String methodName) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Invoking a removeFrom should only have a single argument");
        }
        this.resolveIfRequired(targetAdapter);
        Object argumentObj = this.underlying(args[0]);
        if (argumentObj == null) {
            throw new IllegalArgumentException("Must provide a non-null object to remove");
        }
        NakedObject argumentAdapter = this.getRuntimeContext().adapterFor(argumentObj);
        InteractionResult interactionResult = otma.isValidToRemove(targetAdapter, argumentAdapter).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == HeadlessViewer.ExecutionMode.EXECUTE) {
            otma.removeElement(targetAdapter, argumentAdapter);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object handleActionMethod(Object[] args, AuthenticationSession session, NakedObject targetAdapter, NakedObjectAction noa, String memberName) {
        Object[] underlyingArgs = new Object[args.length];
        int i = 0;
        for (Object arg : args) {
            underlyingArgs[i++] = this.underlying(arg);
        }
        NakedObject[] argAdapters = new NakedObject[underlyingArgs.length];
        int j = 0;
        for (Object underlyingArg : underlyingArgs) {
            argAdapters[j++] = underlyingArg != null ? this.getRuntimeContext().adapterFor(underlyingArg) : null;
        }
        InteractionResult interactionResult = noa.isProposedArgumentSetValid(targetAdapter, argAdapters).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
        if (this.getExecutionMode() == HeadlessViewer.ExecutionMode.EXECUTE) {
            NakedObject actionReturnNO = noa.execute(targetAdapter, argAdapters);
            return NakedObjectUtils.unwrap((NakedObject)actionReturnNO);
        }
        this.objectChangedIfRequired(targetAdapter);
        return null;
    }

    private Object underlying(Object arg) {
        if (arg instanceof ViewObject) {
            ViewObject argViewObject = (ViewObject)arg;
            return argViewObject.underlying();
        }
        return arg;
    }

    private void checkVisibility(AuthenticationSession session, NakedObject targetNakedObject, NakedObjectMember nakedObjectMember) {
        InteractionResult interactionResult = nakedObjectMember.isVisible(this.getAuthenticationSession(), targetNakedObject).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void checkUsability(AuthenticationSession session, NakedObject targetNakedObject, NakedObjectMember nakedObjectMember) {
        InteractionResult interactionResult = nakedObjectMember.isUsable(this.getAuthenticationSession(), targetNakedObject).getInteractionResult();
        this.notifyListenersAndVetoIfRequired(interactionResult);
    }

    private void notifyListenersAndVetoIfRequired(InteractionResult interactionResult) {
        InteractionEvent interactionEvent = interactionResult.getInteractionEvent();
        this.notifyListeners(interactionEvent);
        if (interactionEvent.isVeto()) {
            throw this.toException(interactionEvent);
        }
    }

    private String decode(NakedObjectMember nakedObjectMember) {
        if (nakedObjectMember instanceof OneToOneAssociation) {
            return "a property";
        }
        if (nakedObjectMember instanceof OneToManyAssociation) {
            return "a collection";
        }
        if (nakedObjectMember instanceof NakedObjectAction) {
            return "an action";
        }
        return "an UNKNOWN member type";
    }

    private InteractionException toException(InteractionEvent interactionEvent) {
        if (!interactionEvent.isVeto()) {
            throw new IllegalArgumentException("Provided interactionEvent must be a veto");
        }
        if (interactionEvent instanceof ValidityEvent) {
            ValidityEvent validityEvent = (ValidityEvent)interactionEvent;
            return new InvalidException((InteractionEvent)validityEvent);
        }
        if (interactionEvent instanceof VisibilityEvent) {
            VisibilityEvent visibilityEvent = (VisibilityEvent)interactionEvent;
            return new HiddenException((InteractionEvent)visibilityEvent);
        }
        if (interactionEvent instanceof UsabilityEvent) {
            UsabilityEvent usabilityEvent = (UsabilityEvent)interactionEvent;
            return new DisabledException((InteractionEvent)usabilityEvent);
        }
        throw new IllegalArgumentException("Provided interactionEvent must be a VisibilityEvent, UsabilityEvent or a ValidityEvent");
    }

    private NakedObjectMember locateAndCheckMember(Method method) {
        JavaSpecification javaSpecification = this.getJavaSpecificationOfOwningClass(method);
        NakedObjectMember member = javaSpecification.getMember(method);
        if (member == null) {
            String methodName = method.getName();
            throw new UnsupportedOperationException("Method '" + methodName + "' being invoked does not correspond to any of the object's fields or actions.");
        }
        return member;
    }

    private String checkPrefix(String methodName) {
        String prefix = new MethodPrefixFinder().findPrefix(methodName);
        if (StringUtils.in((String)prefix, (String[])Constants.INVALID_PREFIXES)) {
            throw new UnsupportedOperationException(String.format("Cannot invoke methods with prefix '%s'; use only get/set/addTo/removeFrom/action", prefix));
        }
        return prefix;
    }

    protected boolean isTitleMethod(Method method) {
        return method.equals(this.titleMethod);
    }

    protected boolean isSaveMethod(Method method) {
        return method.equals(this.saveMethod);
    }

    protected boolean isUnderlyingMethod(Method method) {
        return method.equals(this.underlyingMethod);
    }

    private boolean isGetterMethod(String prefix) {
        return prefix.equals("get");
    }

    private boolean isSetterMethod(String prefix) {
        return prefix.equals("set");
    }

    private boolean isAddToMethod(String prefix) {
        return prefix.equals("addTo");
    }

    private boolean isRemoveFromMethod(String prefix) {
        return prefix.equals("removeFrom");
    }

    private boolean isChoicesMethod(String prefix) {
        return prefix.equals("choices");
    }

    private boolean isDefaultMethod(String prefix) {
        return prefix.equals("default");
    }

    private JavaSpecification getJavaSpecificationOfOwningClass(Method method) {
        return this.getJavaSpecification(method.getDeclaringClass());
    }

    private JavaSpecification getJavaSpecification(Class<?> clazz) {
        NakedObjectSpecification nos = this.getSpecification(clazz);
        if (!(nos instanceof JavaSpecification)) {
            throw new UnsupportedOperationException("Only Java is supported (specification is '" + nos.getClass().getCanonicalName() + "')");
        }
        return (JavaSpecification)nos;
    }

    private NakedObjectSpecification getSpecification(Class<?> type) {
        NakedObjectSpecification nos = this.getSpecificationLoader().loadSpecification(type);
        return nos;
    }
}

