/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.viewer.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.applib.events.CollectionMethodEvent;
import org.nakedobjects.applib.events.InteractionEvent;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.plugins.headless.viewer.internal.DelegatingInvocationHandlerDefault;
import org.nakedobjects.plugins.headless.viewer.internal.DomainObjectInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCollectionInvocationHandler<T, C>
extends DelegatingInvocationHandlerDefault<C> {
    private final List<Method> interceptedMethods = new ArrayList<Method>();
    private final List<Method> vetoedMethods = new ArrayList<Method>();
    private final String collectionName;
    private final OneToManyAssociation oneToManyAssociation;
    private final T domainObject;

    public AbstractCollectionInvocationHandler(C collectionOrMapToProxy, String collectionName, DomainObjectInvocationHandler<T> handler, RuntimeContext runtimeContext, OneToManyAssociation otma) {
        super(collectionOrMapToProxy, handler.getHeadlessViewer(), handler.getExecutionMode(), runtimeContext);
        this.collectionName = collectionName;
        this.oneToManyAssociation = otma;
        this.domainObject = handler.getDelegate();
    }

    protected Method intercept(Method method) {
        this.interceptedMethods.add(method);
        return method;
    }

    protected Method veto(Method method) {
        this.vetoedMethods.add(method);
        return method;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public OneToManyAssociation getCollection() {
        return this.oneToManyAssociation;
    }

    public T getDomainObject() {
        return this.domainObject;
    }

    @Override
    public Object invoke(Object collectionObject, Method method, Object[] args) throws Throwable {
        Object returnValueObj = this.delegate(method, args);
        if (this.interceptedMethods.contains(method)) {
            this.resolveIfRequired(this.domainObject);
            CollectionMethodEvent ev = new CollectionMethodEvent(this.getDelegate(), this.getCollection().getIdentifier(), this.getDomainObject(), method.getName(), args, returnValueObj);
            this.notifyListeners((InteractionEvent)ev);
            return returnValueObj;
        }
        if (this.vetoedMethods.contains(method)) {
            throw new UnsupportedOperationException(String.format("Method '%s' may not be called directly.", method.getName()));
        }
        return returnValueObj;
    }
}

