/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.headless.viewer.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nakedobjects.applib.events.ActionArgumentEvent;
import org.nakedobjects.applib.events.ActionInvocationEvent;
import org.nakedobjects.applib.events.ActionUsabilityEvent;
import org.nakedobjects.applib.events.ActionVisibilityEvent;
import org.nakedobjects.applib.events.CollectionAccessEvent;
import org.nakedobjects.applib.events.CollectionAddToEvent;
import org.nakedobjects.applib.events.CollectionMethodEvent;
import org.nakedobjects.applib.events.CollectionRemoveFromEvent;
import org.nakedobjects.applib.events.CollectionUsabilityEvent;
import org.nakedobjects.applib.events.CollectionVisibilityEvent;
import org.nakedobjects.applib.events.InteractionEvent;
import org.nakedobjects.applib.events.ObjectTitleEvent;
import org.nakedobjects.applib.events.ObjectValidityEvent;
import org.nakedobjects.applib.events.PropertyAccessEvent;
import org.nakedobjects.applib.events.PropertyModifyEvent;
import org.nakedobjects.applib.events.PropertyUsabilityEvent;
import org.nakedobjects.applib.events.PropertyVisibilityEvent;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.plugins.headless.applib.HeadlessViewer;
import org.nakedobjects.plugins.headless.applib.ViewObject;
import org.nakedobjects.plugins.headless.applib.listeners.InteractionListener;
import org.nakedobjects.plugins.headless.viewer.internal.InteractionEventDispatcher;
import org.nakedobjects.plugins.headless.viewer.internal.InteractionEventDispatcherTypeSafe;
import org.nakedobjects.plugins.headless.viewer.internal.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessViewerImpl
implements HeadlessViewer {
    private final List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    private final Map<Class<? extends InteractionEvent>, InteractionEventDispatcher> dispatchersByEventClass = new HashMap<Class<? extends InteractionEvent>, InteractionEventDispatcher>();
    private final RuntimeContext runtimeContext;

    public HeadlessViewerImpl(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
        this.dispatchersByEventClass.put(ObjectTitleEvent.class, new InteractionEventDispatcherTypeSafe<ObjectTitleEvent>(){

            @Override
            public void dispatchTypeSafe(ObjectTitleEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.objectTitleRead(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<PropertyVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyVisibilityEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.propertyVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<PropertyUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyUsabilityEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.propertyUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyAccessEvent.class, new InteractionEventDispatcherTypeSafe<PropertyAccessEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyAccessEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.propertyAccessed(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(PropertyModifyEvent.class, new InteractionEventDispatcherTypeSafe<PropertyModifyEvent>(){

            @Override
            public void dispatchTypeSafe(PropertyModifyEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.propertyModified(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<CollectionVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionVisibilityEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.collectionVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<CollectionUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionUsabilityEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.collectionUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionAccessEvent.class, new InteractionEventDispatcherTypeSafe<CollectionAccessEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionAccessEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.collectionAccessed(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionAddToEvent.class, new InteractionEventDispatcherTypeSafe<CollectionAddToEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionAddToEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.collectionAddedTo(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionRemoveFromEvent.class, new InteractionEventDispatcherTypeSafe<CollectionRemoveFromEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionRemoveFromEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.collectionRemovedFrom(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionVisibilityEvent.class, new InteractionEventDispatcherTypeSafe<ActionVisibilityEvent>(){

            @Override
            public void dispatchTypeSafe(ActionVisibilityEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.actionVisible(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionUsabilityEvent.class, new InteractionEventDispatcherTypeSafe<ActionUsabilityEvent>(){

            @Override
            public void dispatchTypeSafe(ActionUsabilityEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.actionUsable(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionArgumentEvent.class, new InteractionEventDispatcherTypeSafe<ActionArgumentEvent>(){

            @Override
            public void dispatchTypeSafe(ActionArgumentEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.actionArgument(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ActionInvocationEvent.class, new InteractionEventDispatcherTypeSafe<ActionInvocationEvent>(){

            @Override
            public void dispatchTypeSafe(ActionInvocationEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.actionInvoked(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(ObjectValidityEvent.class, new InteractionEventDispatcherTypeSafe<ObjectValidityEvent>(){

            @Override
            public void dispatchTypeSafe(ObjectValidityEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.objectPersisted(interactionEvent);
                }
            }
        });
        this.dispatchersByEventClass.put(CollectionMethodEvent.class, new InteractionEventDispatcherTypeSafe<CollectionMethodEvent>(){

            @Override
            public void dispatchTypeSafe(CollectionMethodEvent interactionEvent) {
                for (InteractionListener l : HeadlessViewerImpl.this.getListeners()) {
                    l.collectionMethodInvoked(interactionEvent);
                }
            }
        });
    }

    public <T> T view(T domainObject) {
        return this.view(domainObject, HeadlessViewer.ExecutionMode.EXECUTE);
    }

    public <T> T view(T domainObject, HeadlessViewer.ExecutionMode mode) {
        if (this.isView(domainObject)) {
            return domainObject;
        }
        return Proxy.proxy(domainObject, this, mode, this.runtimeContext);
    }

    public boolean isView(Object possibleView) {
        return possibleView instanceof ViewObject;
    }

    public List<InteractionListener> getListeners() {
        return this.listeners;
    }

    public boolean addInteractionListener(InteractionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeInteractionListener(InteractionListener listener) {
        return this.listeners.remove(listener);
    }

    public void notifyListeners(InteractionEvent interactionEvent) {
        InteractionEventDispatcher dispatcher = this.dispatchersByEventClass.get(interactionEvent.getClass());
        if (dispatcher == null) {
            throw new RuntimeException("Unknown InteractionEvent - register into dispatchers map");
        }
        dispatcher.dispatch(interactionEvent);
    }
}

