/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.easymock.MockControl;
import org.hibernate.Hibernate;
import org.hibernate.usertype.UserType;
import org.nakedobjects.applib.value.Color;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.ColorType;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.TypesTestCase;

public class ColorTypeTest
extends TypesTestCase {
    public void testNullSafeGetNotNull() throws Exception {
        int value = 4;
        MockControl control = MockControl.createControl(ResultSet.class);
        ResultSet rs = (ResultSet)control.getMock();
        control.expectAndReturn(rs.getInt(names[0]), 4);
        control.expectAndReturn((Object)rs.wasNull(), (Object)false);
        control.replay();
        ColorType type = new ColorType();
        Color returned = (Color)type.nullSafeGet(rs, names, null);
        ColorTypeTest.assertEquals((String)"color", (int)4, (int)returned.intValue());
        control.verify();
    }

    public void testNullSafeGetIsNull() throws Exception {
        MockControl control = MockControl.createControl(ResultSet.class);
        ResultSet rs = (ResultSet)control.getMock();
        control.expectAndReturn(rs.getInt(names[0]), 0);
        control.expectAndReturn((Object)rs.wasNull(), (Object)true);
        control.replay();
        ColorType type = new ColorType();
        ColorTypeTest.assertNull((Object)type.nullSafeGet(rs, names, null));
        control.verify();
    }

    public void testNullSafeSetNotNull() throws Exception {
        int value = 5;
        Color color = new Color(5);
        MockControl control = MockControl.createControl(PreparedStatement.class);
        PreparedStatement ps = (PreparedStatement)control.getMock();
        ps.setInt(1, 5);
        control.replay();
        ColorType type = new ColorType();
        type.nullSafeSet(ps, (Object)color, 1);
        control.verify();
    }

    public void testNullSafeSetIsNull() throws Exception {
        MockControl control = MockControl.createControl(PreparedStatement.class);
        PreparedStatement ps = (PreparedStatement)control.getMock();
        ps.setNull(1, Hibernate.INTEGER.sqlType());
        control.replay();
        ColorType type = new ColorType();
        type.nullSafeSet(ps, null, 1);
        control.verify();
    }

    public void testBasics() {
        ColorType type = new ColorType();
        super.basicTest((UserType)type);
        ColorTypeTest.assertEquals((String)"returned class", Color.class, (Object)type.returnedClass());
    }
}

