/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;

public class HibernateOidCopyFrom {
    @Test
    public void isEquals() {
        HibernateOid one = HibernateOid.createPersistent(HibernateOidCopyFrom.class, (Serializable)((Object)"one"));
        HibernateOid copy = HibernateOid.createTransient(Object.class, (long)2L);
        Assert.assertFalse((boolean)one.equals((Object)copy));
        copy.copyFrom((Oid)one);
        Assert.assertEquals((Object)one, (Object)copy);
    }

    @Test
    public void syncsTheHibernateId() {
        HibernateOid one = HibernateOid.createPersistent(HibernateOidCopyFrom.class, (Serializable)((Object)"one"));
        HibernateOid copy = HibernateOid.createTransient(Object.class, (long)2L);
        copy.copyFrom((Oid)one);
        Assert.assertEquals((Object)one.getHibernateId(), (Object)copy.getHibernateId());
    }

    @Test
    public void transientStateIsCopiedOver() {
        HibernateOid oid = HibernateOid.createTransient(Object.class, (long)2L);
        HibernateOid oidCopy = HibernateOid.createPersistent(Object.class, (Serializable)((Object)"x"));
        Assert.assertNull((Object)oid.getHibernateId());
        Assert.assertTrue((boolean)oid.isTransient());
        Assert.assertNotNull((Object)oidCopy.getHibernateId());
        Assert.assertFalse((boolean)oidCopy.isTransient());
        oidCopy.copyFrom((Oid)oid);
        Assert.assertNull((Object)oidCopy.getHibernateId());
        Assert.assertTrue((boolean)oidCopy.isTransient());
    }

    @Test
    public void persistentStateIsCopiedOver() {
        HibernateOid oid = HibernateOid.createPersistent(Object.class, (Serializable)((Object)"x"));
        HibernateOid oidCopy = HibernateOid.createTransient(Object.class, (long)2L);
        Assert.assertNotNull((Object)oid.getHibernateId());
        Assert.assertFalse((boolean)oid.isTransient());
        Assert.assertNull((Object)oidCopy.getHibernateId());
        Assert.assertTrue((boolean)oidCopy.isTransient());
        oidCopy.copyFrom((Oid)oid);
        Assert.assertNotNull((Object)oidCopy.getHibernateId());
        Assert.assertFalse((boolean)oidCopy.isTransient());
    }

    @Test
    public void previousStateIsCopiedOver() {
        HibernateOid oid = HibernateOid.createTransient(Object.class, (long)2L);
        HibernateOid oidCopy = HibernateOid.createPersistent(Object.class, (Serializable)((Object)"x"));
        oidCopy.copyFrom((Oid)oid);
        Assert.assertFalse((boolean)oid.hasPrevious());
    }
}

