/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoderBuffer;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoderBuffer;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class HibernateOidDecodeability {
    private PipedInputStream pipedInputStream;
    private PipedOutputStream pipedOutputStream;
    private ByteEncoderBuffer encoder;
    private ByteDecoderBuffer decoder;
    private HibernateOid oid;
    private HibernateOid oid2;
    private final Class<?> clazz;
    private final Long primaryKey;
    private final Long hibernateId;

    @Parameterized.Parameters
    public static Collection<?> data() {
        return Arrays.asList({Object.class, 123, -1}, {Object.class, 123, 456});
    }

    public HibernateOidDecodeability(Class<?> clazz, long primaryKey, long hibernateId) {
        this.clazz = clazz;
        this.primaryKey = primaryKey;
        this.hibernateId = hibernateId;
    }

    @Before
    public void setUp() throws IOException {
        this.pipedInputStream = new PipedInputStream();
        this.pipedOutputStream = new PipedOutputStream(this.pipedInputStream);
        this.encoder = new ByteEncoderBuffer((OutputStream)this.pipedOutputStream);
        this.decoder = new ByteDecoderBuffer((InputStream)this.pipedInputStream);
    }

    @Test
    public void shouldBeAbleToDecodeHibernateOids() {
        this.oid = HibernateOid.createTransient(this.clazz, (Serializable)this.primaryKey);
        if (this.hibernateId != -1L) {
            this.oid.setHibernateId((Serializable)this.hibernateId);
            this.oid.makePersistent();
        }
        this.oid.encode((ByteEncoder)this.encoder);
        this.oid2 = new HibernateOid((ByteDecoder)this.decoder);
        Assert.assertThat((Object)this.oid2.getClassName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.oid.getClassName())));
        Assert.assertThat((Object)this.oid2.getHibernateId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.oid.getHibernateId())));
        Assert.assertThat((Object)this.oid2.getPrevious(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.oid.getPrevious())));
        Assert.assertThat((Object)this.oid2.getPrimaryKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.oid.getPrimaryKey())));
        Assert.assertThat((Object)this.oid2.isTransient(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.oid.isTransient())));
    }
}

