/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.container;

import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.services.container.DomainObjectContainerDefault;
import org.nakedobjects.plugins.hibernate.objectstore.util.HibernateUtil;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;

public class HibernateContainer
extends DomainObjectContainerDefault {
    private static final Logger LOG = Logger.getLogger(HibernateContainer.class);

    public void resolve(Object parent, Object field) {
        if (field == null) {
            super.resolve(parent);
            return;
        }
        NakedObject adapter = this.getRuntimeContext().getAdapterFor(parent);
        ResolveState resolveState = adapter.getResolveState();
        if (!resolveState.isResolvable(ResolveState.RESOLVING)) {
            return;
        }
        if (Hibernate.isInitialized((Object)field)) {
            return;
        }
        HibernateContainer.getTransactionManager().startTransaction();
        try {
            Session session = HibernateUtil.getCurrentSession();
            if (field instanceof PersistentCollection) {
                session.lock(parent, LockMode.NONE);
                Hibernate.initialize((Object)field);
            } else {
                LazyInitializer lazy = ((HibernateProxy)field).getHibernateLazyInitializer();
                lazy.setSession((SessionImplementor)session);
                lazy.initialize();
            }
        }
        catch (RuntimeException e) {
            HibernateContainer.getTransactionManager().abortTransaction();
            throw e;
        }
        HibernateContainer.getTransactionManager().endTransaction();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Container resolved field of type " + field.getClass() + " for parent " + parent + ", state=" + resolveState));
        }
    }

    protected static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    protected static NakedObjectTransactionManager getTransactionManager() {
        return HibernateContainer.getPersistenceSession().getTransactionManager();
    }
}

