/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.nakedobjects.applib.value.Money;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.ImmutableCompositeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoneyType
extends ImmutableCompositeType {
    public Class<Money> returnedClass() {
        return Money.class;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SessionImplementor session, Object owner) throws SQLException {
        BigDecimal amount = resultSet.getBigDecimal(names[0]);
        if (resultSet.wasNull()) {
            return null;
        }
        String currency = resultSet.getString(names[1]);
        return new Money(amount.doubleValue(), currency);
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index, SessionImplementor session) throws SQLException {
        if (value == null) {
            statement.setNull(index, Hibernate.BIG_DECIMAL.sqlType());
            statement.setNull(index + 1, Hibernate.STRING.sqlType());
        } else {
            Money amount = (Money)value;
            statement.setBigDecimal(index, amount.getAmount());
            statement.setString(index + 1, amount.getCurrency());
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"amount", "currency"};
    }

    public Type[] getPropertyTypes() {
        return new Type[]{Hibernate.BIG_DECIMAL, Hibernate.STRING};
    }

    public Object getPropertyValue(Object component, int property) {
        Money monetaryAmount = (Money)component;
        if (property == 0) {
            return monetaryAmount.getAmount();
        }
        return monetaryAmount.getCurrency();
    }

    public void setPropertyValue(Object component, int property, Object value) {
        throw new UnsupportedOperationException("Money is immutable");
    }
}

