package org.nakedobjects.plugins.hibernate.objectstore.metamodel.criteria;

import org.nakedobjects.plugins.remoting.shared.data.CriteriaDataAbstract;
import org.nakedobjects.plugins.remoting.shared.data.Data;


public class HibernateQueryData extends CriteriaDataAbstract {

    private static final long serialVersionUID = 1L;
    private final int resultType;
    private final Data[] objectData;
    private final byte[] queryAsBytes;

    public HibernateQueryData(final HibernateQueryCriteria criteria, final byte[] queryAsBytes, final Data[] data) {
        super(criteria);
        this.objectData = data;
        this.queryAsBytes = queryAsBytes;
        resultType = criteria.getResultType();
    }

    public Data[] getData() {
        return objectData;
    }

    public Class<HibernateQueryCriteria> getCriteriaClass() {
        return HibernateQueryCriteria.class;
    }

    public int getResultType() {
        return resultType;
    }

    public byte[] getQueryAsBytes() {
        return queryAsBytes;
    }
}
