package org.nakedobjects.plugins.hibernate.objectstore.metamodel.criteria;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.criteria.InstancesCriteria;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.Parameter;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.query.QueryPlaceholder;
import org.nakedobjects.plugins.remoting.shared.CriteriaEncoderAbstract;
import org.nakedobjects.plugins.remoting.shared.ObjectEncoder;
import org.nakedobjects.plugins.remoting.shared.data.CriteriaData;
import org.nakedobjects.plugins.remoting.shared.data.Data;
import org.nakedobjects.plugins.remoting.shared.data.KnownObjects;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;


public class HibernateQueryEncoder extends CriteriaEncoderAbstract {
    public CriteriaData createData(final InstancesCriteria criteria, final ObjectEncoder encoder) {
        final HibernateQueryCriteria hibernateCriteria = (HibernateQueryCriteria) criteria;
        final List<Parameter> parms = hibernateCriteria.getQuery().getParameters();
        final NakedObjectSpecification[] specs = new NakedObjectSpecification[parms.size()];
        final NakedObject[] objects = new NakedObject[parms.size()];
        for (int i = 0; i < parms.size(); i++) {
            final Parameter parm = parms.get(i);
            final NakedObject nakedObject = getAdapterManager().getAdapterFor(parm.getValue());
            specs[i] = nakedObject.getSpecification();
            objects[i] = nakedObject;
        }
        final Data[] objectData = encoder.createParameters(specs, objects, new KnownObjects());
        final byte[] serialisedQuery = serialise(hibernateCriteria.getQuery());
        return new HibernateQueryData((HibernateQueryCriteria) criteria, serialisedQuery, objectData);
    }

    // REVIEW serialise query inline here as part of strategy rather than in Marshaller - correct ?
    private byte[] serialise(final Object toSerialise) {
        try {
            final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            final ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            objectStream.writeObject(toSerialise);
            objectStream.flush();
            return byteStream.toByteArray();
        } catch (final Exception e) {
            throw new NakedObjectException(e);
        }
    }

    private Object deSerialise(final byte[] bytes) {
        try {
            final ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            final ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            return objectStream.readObject();
        } catch (final Exception e) {
            throw new NakedObjectException(e);
        }
    }

    @Override
    protected InstancesCriteria doRestore(
            final NakedObjectSpecification specification,
            final CriteriaData criteriaData,
            final ObjectEncoder encoder) {

        final HibernateQueryData queryData = (HibernateQueryData) criteriaData;
        final QueryPlaceholder query = (QueryPlaceholder) deSerialise(queryData.getQueryAsBytes());

        for (int i = 0; i < queryData.getData().length; i++) {
            final Parameter parm = query.getParameters().get(i);
            final Data data = queryData.getData()[i];
            final NakedObject nakedObject = encoder.restore(data);
            parm.setValue(nakedObject.getObject());
        }

        return new HibernateQueryCriteria(criteriaData.getCriteriaClass(), query, ((HibernateQueryData) criteriaData)
                .getResultType());
    }

    public Class<HibernateQueryCriteria> getCriteriaClass() {
        return HibernateQueryCriteria.class;
    }

    
    
    //////////////////////////////////////////////////////////
    // Dependencies (from context)
    //////////////////////////////////////////////////////////
    
    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static AdapterManager getAdapterManager() {
        return getPersistenceSession().getAdapterManager();
    }
    

}
