/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.easymock.MockControl;
import org.hibernate.Hibernate;
import org.hibernate.usertype.UserType;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.TimeType;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.usertype.TypesTestCase;

public class TimeTypeTest
extends TypesTestCase {
    public static TimeZone timeZone = TimeZone.getTimeZone("GMT");

    public void testNullSafeGetNotNull() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(timeZone);
        cal.set(11, 18);
        cal.set(12, 5);
        Time returnedTime = new Time(cal.getTimeInMillis());
        MockControl control = MockControl.createControl(ResultSet.class);
        ResultSet rs = (ResultSet)control.getMock();
        control.expectAndReturn((Object)rs.getTime(names[0]), (Object)returnedTime);
        control.expectAndReturn((Object)rs.wasNull(), (Object)false);
        control.replay();
        TimeType type = new TimeType();
        org.nakedobjects.applib.value.Time returned = (org.nakedobjects.applib.value.Time)type.nullSafeGet(rs, names, null);
        TimeTypeTest.assertEquals((String)"hour", (int)18, (int)returned.getHour());
        TimeTypeTest.assertEquals((String)"min", (int)5, (int)returned.getMinute());
        control.verify();
    }

    public void testNullSafeGetIsNull() throws Exception {
        MockControl control = MockControl.createControl(ResultSet.class);
        ResultSet rs = (ResultSet)control.getMock();
        control.expectAndReturn((Object)rs.getTime(names[0]), null);
        control.expectAndReturn((Object)rs.wasNull(), (Object)true);
        control.replay();
        TimeType type = new TimeType();
        TimeTypeTest.assertNull((Object)type.nullSafeGet(rs, names, null));
        control.verify();
    }

    public void testNullSafeSetNotNull() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(timeZone);
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(1, 1970);
        cal.set(11, 18);
        cal.set(12, 5);
        cal.set(13, 0);
        cal.set(14, 0);
        Time sqlTime = new Time(cal.getTimeInMillis());
        org.nakedobjects.applib.value.Time Time2 = new org.nakedobjects.applib.value.Time((Date)sqlTime);
        MockControl control = MockControl.createControl(PreparedStatement.class);
        PreparedStatement ps = (PreparedStatement)control.getMock();
        ps.setTime(1, sqlTime);
        control.replay();
        TimeType type = new TimeType();
        type.nullSafeSet(ps, (Object)Time2, 1);
        control.verify();
    }

    public void testNullSafeSetIsNull() throws Exception {
        MockControl control = MockControl.createControl(PreparedStatement.class);
        PreparedStatement ps = (PreparedStatement)control.getMock();
        ps.setNull(1, Hibernate.TIME.sqlType());
        control.replay();
        TimeType type = new TimeType();
        type.nullSafeSet(ps, null, 1);
        control.verify();
    }

    public void testBasics() {
        TimeType type = new TimeType();
        super.basicTest((UserType)type);
        TimeTypeTest.assertEquals((String)"returned class", org.nakedobjects.applib.value.Time.class, (Object)type.returnedClass());
    }
}

