/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.tools.internal;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.Association;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.PersistentNakedClass;
import org.nakedobjects.runtime.context.NakedObjectsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentNakedClasses {
    private final HashMap<String, PersistentNakedClass> classes = new HashMap();
    private final HashMap<String, PersistentNakedClass> interfaces = new HashMap();
    private final PersistentNakedClass rootClass = new PersistentNakedClass();
    private boolean assumeBidirectional = true;

    public static PersistentNakedClasses buildPersistentNakedClasses(Boolean assumeBidirectional) {
        PersistentNakedClasses classes = assumeBidirectional == null ? new PersistentNakedClasses() : new PersistentNakedClasses(assumeBidirectional);
        classes.buildClassMaps();
        return classes;
    }

    protected PersistentNakedClasses() {
        this(NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.persistence.hibernate.assumeBidirectional", true));
    }

    protected PersistentNakedClasses(boolean assumeBidirectional) {
        this.assumeBidirectional = assumeBidirectional;
    }

    protected void buildClassMaps() {
        NakedObjectSpecification objectSpec = NakedObjectsContext.getSpecificationLoader().loadSpecification(Object.class);
        this.buildClassHierachy(objectSpec, this.rootClass);
        this.findInterfaces(this.classes.values().toArray(new PersistentNakedClass[0]));
        this.optimiseInterfaces();
        this.checkAssociations();
        this.removeUnusedAbstractClasses();
        this.assignTableNames();
        this.checkInverseAssociations();
        if (this.assumeBidirectional) {
            this.mapAssociations();
        }
        this.markVersionInfo();
    }

    public String debugString() {
        StringBuffer sb = new StringBuffer(2048);
        this.rootClass.debugString(sb, "    C--");
        Iterator<PersistentNakedClass> iter = this.interfaces.values().iterator();
        while (iter.hasNext()) {
            iter.next().debugString(sb, "    I--");
        }
        return sb.toString();
    }

    public PersistentNakedClass getPersistentClass(String name) {
        return this.classes.get(name);
    }

    public Iterator<PersistentNakedClass> getPersistentClasses() {
        return this.classes.values().iterator();
    }

    public boolean isPersistentClass(String name) {
        return this.classes.containsKey(name);
    }

    public boolean isPersistentInterface(String name) {
        return this.interfaces.containsKey(name);
    }

    private void mapAssociations() {
        for (PersistentNakedClass thisPersistentClass : this.classes.values()) {
            NakedObjectAssociation[] uniqueFields = thisPersistentClass.getUniqueFields();
            for (int i = 0; i < uniqueFields.length; ++i) {
                NakedObjectAssociation associatedField;
                PersistentNakedClass associatedClass;
                String associatedClassName;
                NakedObjectAssociation field = uniqueFields[i];
                if (field.getSpecification().isAggregated() || !field.isPersisted() || thisPersistentClass.hasAssociation(field.getId()) || !thisPersistentClass.isUniqueAssociation(associatedClassName = field.getSpecification().getFullName()) || (associatedClass = this.getPersistentClass(associatedClassName)) == null || (associatedField = associatedClass.getUniqueAssociation(thisPersistentClass.getName())) == null || associatedClass.hasAssociation(associatedField.getId())) continue;
                boolean inverse = field.isOneToOneAssociation() ? (associatedField.isOneToOneAssociation() ? associatedClassName.compareTo(thisPersistentClass.getName()) < 0 : false) : (associatedField.isOneToOneAssociation() ? true : associatedClassName.compareTo(thisPersistentClass.getName()) < 0);
                Association association = new Association(associatedClass, associatedField, inverse);
                thisPersistentClass.addAssociation(field.getId(), association);
                Association reverseAssociation = new Association(thisPersistentClass, field, !inverse);
                associatedClass.addAssociation(associatedField.getId(), reverseAssociation);
            }
        }
    }

    private void checkInverseAssociations() {
        for (PersistentNakedClass persistentClass : this.classes.values()) {
            NakedObjectAssociation[] fields = persistentClass.getUniqueFields();
            for (int i = 0; i < fields.length; ++i) {
                String inverse;
                PersistentNakedClass associatedClass;
                if (fields[i].getSpecification().isAggregated() || !fields[i].isPersisted() || (associatedClass = this.getPersistentClass(fields[i].getSpecification().getFullName())) == null || (inverse = this.getInverse(persistentClass, fields[i].getId())) == null) continue;
                NakedObjectAssociation associatedField = associatedClass.getSpecification().getAssociation(inverse);
                Association association = new Association(associatedClass, associatedField, false);
                persistentClass.addAssociation(fields[i].getId(), association);
                Association reverseAssociation = new Association(persistentClass, fields[i], true);
                associatedClass.addAssociation(inverse, reverseAssociation);
            }
        }
    }

    private String getInverse(PersistentNakedClass persistentClass, String fieldName) {
        Class<?> clazz;
        try {
            clazz = Class.forName(persistentClass.getSpecification().getFullName());
        }
        catch (ClassNotFoundException e) {
            throw new NakedObjectException((Throwable)e);
        }
        String nameWithNoSpaces = fieldName.replace(" ", "");
        String capitalizedName = nameWithNoSpaces.substring(0, 1).toUpperCase() + nameWithNoSpaces.substring(1);
        try {
            Field field = clazz.getField("inverse" + capitalizedName);
            return Introspector.decapitalize((String)field.get(clazz));
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return null;
    }

    private void markVersionInfo() {
        this.markVersionInfo(this.rootClass.getSubClasses());
    }

    private void markVersionInfo(Iterator<PersistentNakedClass> subClasses) {
        Iterator<PersistentNakedClass> iter = subClasses;
        while (iter.hasNext()) {
            PersistentNakedClass persistentClass = iter.next();
            if (persistentClass.isAbstract()) {
                this.markVersionInfo(persistentClass.getSubClasses());
                continue;
            }
            persistentClass.setRequireVersion(true);
        }
    }

    private void assignTableNames() {
        NakedObjectConfiguration config = NakedObjectsContext.getConfiguration();
        HashMap<String, PersistentNakedClass> tableNames = new HashMap<String, PersistentNakedClass>(this.classes.size() * 2);
        for (PersistentNakedClass persistentClass : this.classes.values()) {
            String fullName = persistentClass.getName();
            String candidate = config.getString("nakedobjects.persistence.hibernate.table." + fullName);
            candidate = candidate != null ? candidate.trim().toUpperCase() : fullName.substring(fullName.lastIndexOf(46) + 1).toUpperCase();
            if (tableNames.containsKey(candidate)) {
                this.duplicateTableName(tableNames, persistentClass, candidate);
                PersistentNakedClass duplicate = tableNames.get(candidate);
                if (duplicate == null) continue;
                tableNames.put(candidate, null);
                this.duplicateTableName(tableNames, duplicate, candidate);
                continue;
            }
            tableNames.put(candidate, persistentClass);
            persistentClass.setTableName(candidate);
        }
    }

    private void duplicateTableName(HashMap<String, PersistentNakedClass> tableNames, PersistentNakedClass persistentClass, String candidate) {
        persistentClass.setDuplicateUnqualifiedClassName(true);
        String fullName = persistentClass.getName();
        String remaining = fullName.substring(0, fullName.length() - candidate.length() - 1);
        this.assignTableName(tableNames, persistentClass, remaining, candidate);
    }

    private void assignTableName(HashMap<String, PersistentNakedClass> tableNames, PersistentNakedClass persistentClass, String remaining, String lastCandidate) {
        int lastDot = remaining.lastIndexOf(46);
        String candidate = remaining.substring(lastDot + 1).toUpperCase() + "_" + lastCandidate;
        if (tableNames.containsKey(candidate)) {
            if (lastDot == -1) {
                throw new NakedObjectException("Cannot create unique table name for" + persistentClass.getName());
            }
            this.assignTableName(tableNames, persistentClass, remaining.substring(0, lastDot), candidate);
        } else {
            tableNames.put(candidate, persistentClass);
            persistentClass.setTableName(candidate);
        }
    }

    private void checkAssociations() {
        PersistentNakedClass[] persistentClasses = this.classes.values().toArray(new PersistentNakedClass[0]);
        for (int i = 0; i < persistentClasses.length; ++i) {
            NakedObjectAssociation[] fields = persistentClasses[i].getSpecification().getAssociations();
            for (int j = 0; j < fields.length; ++j) {
                NakedObjectAssociation field = fields[j];
                if (!field.isPersisted() || field.getSpecification().isService() || field.getSpecification().getFullName().startsWith("java.") || field.getSpecification().isAggregated()) continue;
                String associatedClassName = field.getSpecification().getFullName();
                if (!this.classes.containsKey(associatedClassName) && !this.interfaces.containsKey(associatedClassName)) {
                    throw new NakedObjectException("Missing class/interface: " + field.getSpecification().getFullName());
                }
                PersistentNakedClass associatedClass = this.classes.get(associatedClassName);
                if (associatedClass == null) continue;
                associatedClass.addReference();
            }
        }
    }

    private void findInterfaces(PersistentNakedClass[] subclasses) {
        ArrayList<PersistentNakedClass> added = new ArrayList<PersistentNakedClass>();
        for (int i = 0; i < subclasses.length; ++i) {
            NakedObjectSpecification[] implementedInterfaces = subclasses[i].getSpecification().interfaces();
            for (int j = 0; j < implementedInterfaces.length; ++j) {
                NakedObjectSpecification implementedInterface = implementedInterfaces[j];
                String interfaceName = implementedInterface.getFullName();
                if (this.interfaces.containsKey(interfaceName)) continue;
                PersistentNakedClass persistentInterface = new PersistentNakedClass(implementedInterface, this.rootClass);
                this.interfaces.put(interfaceName, persistentInterface);
                added.add(persistentInterface);
            }
        }
        if (added.size() > 0) {
            this.findInterfaces(added.toArray(new PersistentNakedClass[0]));
        }
    }

    private void buildClassHierachy(NakedObjectSpecification parentSpec, PersistentNakedClass parentPersistentClass) {
        NakedObjectSpecification[] childSpecs = parentSpec.subclasses();
        for (int i = 0; i < childSpecs.length; ++i) {
            NakedObjectSpecification childSpec = childSpecs[i];
            if (childSpec.isEncodeable() || childSpec.persistability() == Persistability.TRANSIENT || childSpec.isService()) continue;
            String childClassname = childSpec.getFullName();
            PersistentNakedClass childPersistentClass = null;
            if (childSpec.getAssociations().length > 0) {
                try {
                    Class<?> cls = Class.forName(childClassname);
                    if (cls.isArray()) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new NakedObjectException((Throwable)e);
                }
                childPersistentClass = new PersistentNakedClass(childSpec, parentPersistentClass);
                this.classes.put(childSpec.getFullName(), childPersistentClass);
            }
            this.buildClassHierachy(childSpec, childPersistentClass == null ? parentPersistentClass : childPersistentClass);
        }
    }

    private void removeUnusedAbstractClasses() {
        this.removeUnusedAbstractClasses(this.classes.values());
    }

    private void removeUnusedAbstractClasses(Collection<PersistentNakedClass> col) {
        Iterator<PersistentNakedClass> iter = col.iterator();
        while (iter.hasNext()) {
            PersistentNakedClass persistentClass = iter.next();
            if (!persistentClass.isAbstract() || persistentClass.isReferenced()) continue;
            iter.remove();
            persistentClass.removeFromHierarchy();
        }
    }

    private boolean subclassesImplementOnlyThisInterface(NakedObjectSpecification persistentClass, NakedObjectSpecification interfaceToCheck) {
        NakedObjectSpecification[] childSpecs = persistentClass.subclasses();
        for (int i = 0; i < childSpecs.length; ++i) {
            NakedObjectSpecification[] implementedInterfaces;
            NakedObjectSpecification childSpec = childSpecs[i];
            if (childSpec.isEncodeable() || childSpec.persistability() == Persistability.TRANSIENT || (implementedInterfaces = childSpec.interfaces()).length == 0) continue;
            if (implementedInterfaces.length > 1) {
                return false;
            }
            if (!implementedInterfaces[0].getFullName().equals(interfaceToCheck.getFullName())) {
                return false;
            }
            return this.subclassesImplementOnlyThisInterface(childSpec, interfaceToCheck);
        }
        return true;
    }

    private boolean isSubclassOf(NakedObjectSpecification persistentClass, NakedObjectSpecification subclassToCheck) {
        NakedObjectSpecification[] childSpecs = persistentClass.subclasses();
        for (int i = 0; i < childSpecs.length; ++i) {
            NakedObjectSpecification childSpec = childSpecs[i];
            if (childSpec.getFullName().equals(subclassToCheck.getFullName())) {
                return true;
            }
            if (!this.isSubclassOf(childSpec, subclassToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean interfaceImplementedByOtherNonRelatedClass(NakedObjectSpecification implementingClass, NakedObjectSpecification interfaceToCheck) {
        for (PersistentNakedClass otherClass : this.classes.values()) {
            if (implementingClass.equals(otherClass.getSpecification())) continue;
            NakedObjectSpecification[] implementedInterfaces = otherClass.getSpecification().interfaces();
            for (int i = 0; i < implementedInterfaces.length; ++i) {
                if (!implementedInterfaces[i].getFullName().equals(interfaceToCheck.getFullName()) || this.isSubclassOf(implementingClass, otherClass.getSpecification())) continue;
                return true;
            }
        }
        return false;
    }

    private void optimiseInterfaces() {
        PersistentNakedClass[] persistentClasses = this.classes.values().toArray(new PersistentNakedClass[this.classes.values().size()]);
        for (int i = 0; i < persistentClasses.length; ++i) {
            NakedObjectSpecification interfaceToCheck;
            NakedObjectSpecification classToCheck;
            NakedObjectSpecification[] implementedInterfaces;
            PersistentNakedClass persistentClass = persistentClasses[i];
            if (this.classes.containsValue(persistentClass.getParent()) || (implementedInterfaces = persistentClass.getSpecification().interfaces()).length != 1 || !this.subclassesImplementOnlyThisInterface(classToCheck = persistentClass.getSpecification(), interfaceToCheck = implementedInterfaces[0]) || this.interfaceImplementedByOtherNonRelatedClass(classToCheck, interfaceToCheck)) continue;
            PersistentNakedClass persistentInterface = this.interfaces.get(interfaceToCheck.getFullName());
            persistentInterface.setParent(this.rootClass);
            this.interfaces.remove(persistentInterface.getName());
            this.classes.put(persistentInterface.getName(), persistentInterface);
            persistentClass.setParent(persistentInterface);
        }
    }
}

