/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.util;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.event.EventListeners;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.def.DefaultInitializeCollectionEventListener;
import org.hibernate.event.def.DefaultPostLoadEventListener;
import org.hibernate.event.def.DefaultPreLoadEventListener;
import org.hibernate.mapping.Table;
import org.hibernate.transaction.CMTTransactionFactory;
import org.hibernate.transaction.JTATransactionFactory;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.interceptor.NakedInterceptor;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedCollectionInitializeEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedInsertPostEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedInsertPreEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedLoadEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedLoadPostEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedLoadPreEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedUpdatePostEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.listener.NakedUpdatePreEventListener;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.hibspi.session.SessionPlaceHolder;
import org.nakedobjects.plugins.hibernate.objectstore.tools.HibernateTools;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.Nof2HbmXml;
import org.nakedobjects.runtime.context.NakedObjectsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUtil {
    static Logger LOG = Logger.getLogger(HibernateUtil.class);
    private static boolean MANAGED_TRANSACTIONS = false;
    private static SessionFactory sessionFactory;
    private static Object sessionFactoryLock;
    private static boolean initRun;
    private static final String FILE_SEPERATOR;
    private static final String sql92keywords = "ABSOLUTE,ACTION,ADA,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHARACTER_LENGTH,CHAR_LENGTH,CHECK,CLOSE,COALESCE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR,DIAGNOSTICS,DISCONNECT,DISTINCT,DOMAIN,DOUBLE,DROP,ELSE,END,END-EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FORTRAN,FOUND,FROM,FULL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INCLUDE,INDEX,INDICATOR,INITIALLY,INNER,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER,MATCH,MAX,MIN,MINUTE,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NEXT,NO,NONE,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,PASCAL,POSITION,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,SCHEMA,SCROLL,SECOND,SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE,SMALLINT,SOME,SPACE,SQL,SQLCA,SQLCODE,SQLERROR,SQLSTATE,SQLWARNING,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR,ZONE";
    private static Map<String, String> keywords;
    public static final String MAPPING_DIR = "mappings";
    static final org.hibernate.Session sessionPlaceholder;
    static boolean regenerate;
    static boolean auto;
    static Configuration configuration;
    static List<String> requiredToMap;

    public static void initialiseSessionFactory() {
        try {
            configuration = HibernateUtil.createConfiguration();
            HibernateUtil.createMapping();
            HibernateUtil.bindListeners();
            String transactionStrategy = configuration.getProperty("hibernate.transaction.factory_class");
            boolean bl = MANAGED_TRANSACTIONS = CMTTransactionFactory.class.getName().equals(transactionStrategy) || JTATransactionFactory.class.getName().equals(transactionStrategy);
            if (configuration.getProperty("hibernate.session_factory_name") != null) {
                configuration.buildSessionFactory();
            }
        }
        catch (Throwable ex) {
            LOG.error((Object)"building SessionFactory failed.", ex);
            throw new NakedObjectException(ex);
        }
    }

    private static List<File> readMappingFiles(String path) {
        ArrayList<File> files = new ArrayList<File>();
        File dir = new File(path);
        if (dir.isDirectory()) {
            LOG.debug((Object)("searching for mapping file in " + dir.getAbsolutePath()));
            files.addAll(Arrays.asList(dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".hbm.xml");
                }
            })));
            for (File subDir : dir.listFiles()) {
                if (!subDir.isDirectory()) continue;
                files.addAll(HibernateUtil.readMappingFiles(path + FILE_SEPERATOR + subDir.getName()));
            }
        }
        return files;
    }

    static boolean addMappingFilesToConfiguration(Configuration cfg) {
        boolean haveReadAMappingFile = false;
        String path = HibernateUtil.getNofConfiguration().getString("nakedobjects.persistence.hibernate.hbm-export", HibernateUtil.getNofConfiguration().rootPath() + FILE_SEPERATOR + MAPPING_DIR);
        List<File> mappingFiles = HibernateUtil.readMappingFiles(path);
        for (File file : mappingFiles) {
            cfg.addFile(file);
            haveReadAMappingFile = true;
            LOG.info((Object)("reading mapping file: " + file.getAbsolutePath()));
        }
        return haveReadAMappingFile;
    }

    static Configuration createConfiguration() {
        boolean annotations = HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.annotations", false);
        Configuration cfg = annotations ? (Configuration)InstanceFactory.createInstance((String)"org.hibernate.cfg.AnnotationConfiguration") : new Configuration();
        cfg.configure();
        return cfg;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionFactory getSessionFactory() {
        SessionFactory sf = null;
        String sfName = configuration.getProperty("hibernate.session_factory_name");
        if (sfName != null) {
            LOG.debug((Object)"Looking up SessionFactory in JNDI.");
            try {
                sf = (SessionFactory)new InitialContext().lookup(sfName);
            }
            catch (NamingException ex) {
                throw new NakedObjectException((Throwable)ex);
            }
        }
        if (sessionFactory == null) {
            Object object = sessionFactoryLock;
            synchronized (object) {
                if (sessionFactory == null) {
                    sessionFactory = configuration.buildSessionFactory();
                }
            }
        }
        sf = sessionFactory;
        if (sf == null) {
            throw new IllegalStateException("SessionFactory not available.");
        }
        return sf;
    }

    public static org.hibernate.Session getCurrentSession() {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        if (!MANAGED_TRANSACTIONS) {
            Assert.assertTrue((boolean)session.getTransaction().isActive());
        }
        return session;
    }

    public static void startTransaction() {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        if (!MANAGED_TRANSACTIONS) {
            Assert.assertFalse((boolean)session.getTransaction().isActive());
            session.beginTransaction();
        }
    }

    public static boolean inTransaction() {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        if (!MANAGED_TRANSACTIONS) {
            return session.getTransaction().isActive();
        }
        return true;
    }

    public static void commitTransaction() {
        if (!MANAGED_TRANSACTIONS) {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            Transaction tx = session.getTransaction();
            if (tx.isActive()) {
                tx.commit();
            } else {
                session.close();
            }
        }
    }

    public static void rollbackTransaction() {
        try {
            if (!MANAGED_TRANSACTIONS) {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                Transaction tx = session.getTransaction();
                if (tx.isActive()) {
                    tx.rollback();
                } else {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Rollback Failure: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildSessionFactory() {
        LOG.debug((Object)"Rebuilding the SessionFactory from given Configuration.");
        Object object = sessionFactoryLock;
        synchronized (object) {
            if (sessionFactory != null && !sessionFactory.isClosed()) {
                sessionFactory.close();
            }
            if (configuration.getProperty("hibernate.session_factory_name") != null) {
                configuration.buildSessionFactory();
            } else {
                sessionFactory = configuration.buildSessionFactory();
            }
        }
    }

    public static String getRequiredClasses() {
        StringBuffer sb = new StringBuffer(2048);
        Iterator<String> iter = requiredToMap.iterator();
        while (iter.hasNext()) {
            sb.append("\n").append(iter.next());
        }
        return sb.toString();
    }

    private static boolean tableExists(DatabaseMetaData metaData, String catalog, String schema, String table) throws SQLException {
        boolean exists = false;
        ResultSet tablesUC = metaData.getTables(catalog, schema, table.toUpperCase(), new String[]{"TABLE"});
        if (tablesUC.next()) {
            exists = true;
        } else {
            ResultSet tablesLC = metaData.getTables(catalog, schema, table.toLowerCase(), new String[]{"TABLE"});
            if (tablesLC.next()) {
                exists = true;
            }
            tablesLC.close();
        }
        if (exists) {
            LOG.info((Object)("Table '" + table + "' already exists; isInitialized=true"));
        }
        tablesUC.close();
        return exists;
    }

    public static boolean hasInitRun() {
        return initRun;
    }

    public static synchronized boolean init() {
        if (initRun) {
            return true;
        }
        HibernateUtil.initialiseSessionFactory();
        if (MANAGED_TRANSACTIONS) {
            if (HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.schema-export")) {
                LOG.warn((Object)"nakedobjects.persistence.hibernate.schema-export is set, but cannot be run in this environment");
            }
            if (HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.schema-update")) {
                LOG.warn((Object)"nakedobjects.persistence.hibernate.schema-update is set, but cannot be run in this environment");
            }
            initRun = true;
            return true;
        }
        boolean isInitialized = HibernateUtil.isInitialized();
        if (isInitialized) {
            if (HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.schema-update")) {
                HibernateTools.updateSchema(false, true);
            }
        } else if (HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.schema-export", true)) {
            HibernateTools.exportSchema(false, true);
        }
        HibernateUtil.getSessionFactory();
        initRun = true;
        return isInitialized;
    }

    private static boolean isInitialized() {
        NakedObjectConfiguration config = HibernateUtil.getNofConfiguration();
        if (config.hasProperty("nakedobjects.persistence.hibernate.initialized")) {
            return config.getBoolean("nakedobjects.persistence.hibernate.initialized");
        }
        Session session = HibernateUtil.getSessionFactory().openSession();
        Transaction tx = null;
        boolean isInitialized = false;
        try {
            tx = session.beginTransaction();
            DatabaseMetaData metaData = session.connection().getMetaData();
            String tableName = config.getString("nakedobjects.persistence.hibernate.initialized.table");
            if (tableName != null) {
                isInitialized = !HibernateUtil.tableExists(metaData, config.getString("nakedobjects.persistence.hibernate.initialized.catalog"), config.getString("nakedobjects.persistence.hibernate.initialized.schema"), config.getString("nakedobjects.persistence.hibernate.initialized.table"));
            } else {
                Iterator iter = configuration.getTableMappings();
                while (iter.hasNext()) {
                    Table t = (Table)iter.next();
                    if (!t.isPhysicalTable()) continue;
                    isInitialized = HibernateUtil.tableExists(metaData, t.getCatalog(), t.getSchema(), t.getName());
                    break;
                }
            }
            tx.commit();
        }
        catch (SQLException e) {
            tx.rollback();
            throw new NakedObjectException((Throwable)e);
        }
        finally {
            session.close();
        }
        return isInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        LOG.info((Object)"Shutting down Hibernate.");
        if (sessionFactory == null) {
            return;
        }
        boolean shutdown = HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.shutdown", false);
        String url = null;
        if (shutdown && (url = HibernateUtil.getConfiguration().getProperty("connection.url")) != null && url.startsWith("jdbc:hsqldb:")) {
            LOG.info((Object)"Shutdown/compact hsqldb");
            Statement stmt = null;
            try {
                String command = "SHUTDOWN COMPACT";
                HibernateUtil.startTransaction();
                org.hibernate.Session session = HibernateUtil.getCurrentSession();
                LOG.info((Object)"HSQLDB: SHUTDOWN COMPACT");
                stmt = session.connection().createStatement();
                stmt.execute("SHUTDOWN COMPACT");
            }
            catch (Throwable ex) {
                LOG.error((Object)"could not compact database", ex);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)"SQLException", (Throwable)ex);
                    }
                }
            }
        }
        HibernateUtil.rollbackTransaction();
        HibernateUtil.getSessionFactory().close();
        configuration = null;
        sessionFactory = null;
        if (shutdown && url != null && url.startsWith("jdbc:derby:")) {
            LOG.info((Object)"Shutdown Derby");
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("XJ015")) {
                    LOG.info((Object)e.getMessage());
                }
                LOG.error((Object)"Exception in Derby shutdown", (Throwable)e);
            }
        }
    }

    public static boolean isDatabaseKeyword(String potentialKeyword) {
        return keywords.containsKey(potentialKeyword.trim().toUpperCase());
    }

    private static void buildkeywordMap(String keywordCSV) {
        String[] keywordsTokens;
        String allKeywords = "ABSOLUTE,ACTION,ADA,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHARACTER_LENGTH,CHAR_LENGTH,CHECK,CLOSE,COALESCE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR,DIAGNOSTICS,DISCONNECT,DISTINCT,DOMAIN,DOUBLE,DROP,ELSE,END,END-EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FORTRAN,FOUND,FROM,FULL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INCLUDE,INDEX,INDICATOR,INITIALLY,INNER,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER,MATCH,MAX,MIN,MINUTE,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NEXT,NO,NONE,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,PASCAL,POSITION,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,SCHEMA,SCROLL,SECOND,SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE,SMALLINT,SOME,SPACE,SQL,SQLCA,SQLCODE,SQLERROR,SQLSTATE,SQLWARNING,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR,ZONE, " + keywordCSV;
        for (String keyword : keywordsTokens = allKeywords.split(",")) {
            String normalisedKeyword = keyword.trim().toUpperCase();
            if (normalisedKeyword.length() <= 0) continue;
            keywords.put(normalisedKeyword, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getKeywords() {
        String databaseKeywords = "";
        Object object = sessionFactoryLock;
        synchronized (object) {
            Session session = HibernateUtil.getSessionFactory().openSession();
            Transaction tx = null;
            try {
                tx = session.beginTransaction();
                DatabaseMetaData metaData = session.connection().getMetaData();
                databaseKeywords = metaData.getSQLKeywords();
                tx.commit();
            }
            catch (SQLException e) {
                tx.rollback();
                throw new NakedObjectException((Throwable)e);
            }
            finally {
                session.close();
            }
            sessionFactory = null;
        }
        HibernateUtil.buildkeywordMap(databaseKeywords);
    }

    private static boolean isConfigured(String key, boolean defaultValue) {
        return NakedObjectsContext.getConfiguration().getBoolean(key, defaultValue);
    }

    static NakedObjectConfiguration getNofConfiguration() {
        return NakedObjectsContext.getConfiguration();
    }

    static void bindListeners() {
        HibernateUtil.getConfiguration().setInterceptor((Interceptor)new NakedInterceptor());
        EventListeners listeners = HibernateUtil.getConfiguration().getEventListeners();
        listeners.setInitializeCollectionEventListeners(new InitializeCollectionEventListener[]{new DefaultInitializeCollectionEventListener(), new NakedCollectionInitializeEventListener()});
        listeners.setPreLoadEventListeners(new PreLoadEventListener[]{new DefaultPreLoadEventListener(), new NakedLoadPreEventListener()});
        listeners.setLoadEventListeners(new LoadEventListener[]{new NakedLoadEventListener()});
        listeners.setPostLoadEventListeners(new PostLoadEventListener[]{new DefaultPostLoadEventListener(), new NakedLoadPostEventListener()});
        listeners.setPreInsertEventListeners(new PreInsertEventListener[]{new NakedInsertPreEventListener()});
        listeners.setPostInsertEventListeners(new PostInsertEventListener[]{new NakedInsertPostEventListener()});
        listeners.setPreUpdateEventListeners(new PreUpdateEventListener[]{new NakedUpdatePreEventListener()});
        listeners.setPostUpdateEventListeners(new PostUpdateEventListener[]{new NakedUpdatePostEventListener()});
    }

    private static org.hibernate.Session getSessionPlaceHolder() {
        return sessionPlaceholder;
    }

    public static void ensureMapped(NakedObjectSpecification specification) {
        if (HibernateUtil.getConfiguration().getClassMapping(specification.getFullName()) == null) {
            requiredToMap.add(specification.getFullName());
            if (HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.showremappings", false)) {
                LOG.info((Object)("remapping" + HibernateUtil.getRequiredClasses()));
            }
            HibernateUtil.commitTransaction();
            configuration = HibernateUtil.createConfiguration();
            auto = true;
            HibernateUtil.createMapping();
            HibernateUtil.bindListeners();
            if (HibernateUtil.getNofConfiguration().getBoolean("nakedobjects.persistence.hibernate.schema-update")) {
                HibernateTools.updateSchema(configuration, false, true);
            }
            HibernateUtil.rebuildSessionFactory();
        }
    }

    static void createMapping() {
        HibernateUtil.getKeywords();
        Nof2HbmXml nof2HbmXml = null;
        if (auto && regenerate) {
            LOG.info((Object)"(re)generating auto mapping files");
            nof2HbmXml = new Nof2HbmXml();
            nof2HbmXml.createMappingFiles();
        }
        boolean mappingFilesReadIn = HibernateUtil.addMappingFilesToConfiguration(configuration);
        if (auto && !mappingFilesReadIn) {
            LOG.info((Object)"auto mapping DOM to Hibernate database");
            (nof2HbmXml == null ? new Nof2HbmXml() : nof2HbmXml).configure(configuration);
        }
    }

    static {
        sessionFactoryLock = new Object();
        initRun = false;
        FILE_SEPERATOR = System.getProperty("file.separator");
        keywords = new HashMap<String, String>();
        sessionPlaceholder = new SessionPlaceHolder();
        auto = HibernateUtil.isConfigured("nakedobjects.persistence.hibernate.auto", true);
        regenerate = HibernateUtil.isConfigured("nakedobjects.persistence.hibernate.regenerate", false);
        requiredToMap = new ArrayList<String>();
    }
}

