/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.plugins.hibernate.objectstore.persistence.oidgenerator.HibernateOid;

public class HibernateOidMakePersistent {
    private final Serializable primaryKey = "one";
    private final long id = 2L;

    @Test
    public void noLongerTransientPersistent() {
        HibernateOid oid = HibernateOid.createTransient(Object.class, (long)2L);
        Assert.assertTrue((boolean)oid.isTransient());
        oid.setHibernateId((Serializable)((Object)"one"));
        oid.makePersistent();
        Assert.assertFalse((boolean)oid.isTransient());
    }

    @Test
    public void getPreviousPopulatedAndIsEqualToCopy() {
        HibernateOid oid = HibernateOid.createTransient(Object.class, (long)2L);
        HibernateOid oidCopy = HibernateOid.createPersistent(Object.class, (Serializable)((Object)"x"));
        oidCopy.copyFrom((Oid)oid);
        Assert.assertFalse((boolean)oid.hasPrevious());
        oid.setHibernateId((Serializable)((Object)"one"));
        oid.makePersistent();
        Assert.assertTrue((boolean)oid.hasPrevious());
        Assert.assertEquals((Object)oidCopy, (Object)oid.getPrevious());
    }

    @Test
    public void setHibernateIdIsStored() {
        String hibernateId = "one";
        HibernateOid oid = HibernateOid.createTransient(Object.class, (long)2L);
        Assert.assertNull((Object)oid.getHibernateId());
        oid.setHibernateId((Serializable)((Object)hibernateId));
        oid.makePersistent();
        Assert.assertEquals((Object)hibernateId, (Object)oid.getHibernateId());
    }

    @Test
    public void equalToExpected() {
        HibernateOid oid = HibernateOid.createTransient(Object.class, (long)2L);
        oid.setHibernateId((Serializable)((Object)"one"));
        oid.makePersistent();
        HibernateOid expectedPersistent = HibernateOid.createPersistent(Object.class, (Serializable)((Object)"one"));
        Assert.assertEquals((Object)expectedPersistent, (Object)oid);
    }
}

