/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.hibernate.objectstore.tools.internal;

import junit.framework.TestCase;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.hibernate.objectstore.tools.internal.PersistentNakedClass;
import org.nakedobjects.runtime.testsystem.TestSpecification;

public class PersistentNakedClassTest
extends TestCase {
    private static String className = "myclass";
    private PersistentNakedClass root;
    private PersistentNakedClass pc;
    private PersistentNakedClass pc2;
    private PersistentNakedClass pc3;
    private TestSpecification spec;
    private TestSpecification spec2;
    private TestSpecification spec3;

    public void setUp() {
        this.root = new PersistentNakedClass();
        this.spec = new TestSpecification(className);
        this.pc = new PersistentNakedClass((NakedObjectSpecification)this.spec, this.root);
        this.spec2 = new TestSpecification(className + "2");
        this.pc2 = new PersistentNakedClass((NakedObjectSpecification)this.spec2, this.root);
        this.spec3 = new TestSpecification(className + "3");
        this.pc3 = new PersistentNakedClass((NakedObjectSpecification)this.spec3, this.pc2);
    }

    public void tearDown() {
        this.pc3 = null;
        this.pc2 = null;
        this.pc = null;
        this.root = null;
        this.spec3 = null;
        this.spec2 = null;
        this.spec = null;
    }

    public void testBasic() {
        PersistentNakedClass pcDuplicate = new PersistentNakedClass((NakedObjectSpecification)this.spec, this.root);
        PersistentNakedClassTest.assertEquals((String)className, (String)this.pc.getName());
        PersistentNakedClassTest.assertEquals((Object)this.pc, (Object)pcDuplicate);
        PersistentNakedClassTest.assertEquals((String)"name", (String)className, (String)this.pc.getName());
        PersistentNakedClassTest.assertFalse((String)"pc3=pc", (boolean)this.pc3.equals((Object)this.pc));
        PersistentNakedClassTest.assertEquals((String)"parent", (Object)this.pc2, (Object)this.pc3.getParent());
        PersistentNakedClass[] pcSubclasses = this.pc2.getSubClassesArray();
        PersistentNakedClassTest.assertEquals((String)"subclasses size", (int)1, (int)pcSubclasses.length);
        PersistentNakedClassTest.assertEquals((String)"subclasses 0", (Object)this.pc3, (Object)pcSubclasses[0]);
    }

    public void testRemoveFromHierarchy() {
        this.pc2.setParent(this.pc);
        PersistentNakedClassTest.assertEquals((Object)this.pc, (Object)this.pc2.getParent());
        PersistentNakedClassTest.assertEquals((Object)this.pc2, (Object)this.pc3.getParent());
        this.pc2.removeFromHierarchy();
        PersistentNakedClassTest.assertNull((String)"pc2 parent", (Object)this.pc2.getParent());
        PersistentNakedClassTest.assertEquals((String)"pc3 parent", (Object)this.pc, (Object)this.pc3.getParent());
        PersistentNakedClass[] pcSubclasses = this.pc.getSubClassesArray();
        PersistentNakedClassTest.assertEquals((String)"subclasses size", (int)1, (int)pcSubclasses.length);
        PersistentNakedClassTest.assertEquals((String)"subclasses 0", (Object)this.pc3, (Object)pcSubclasses[0]);
    }

    public void testSetParent() {
        PersistentNakedClassTest.assertEquals((Object)this.pc2, (Object)this.pc3.getParent());
        PersistentNakedClassTest.assertEquals((int)0, (int)this.pc.getSubClassesArray().length);
        this.pc3.setParent(this.pc);
        PersistentNakedClassTest.assertEquals((String)"parent", (Object)this.pc, (Object)this.pc3.getParent());
        PersistentNakedClassTest.assertEquals((String)"pc2 subclasses", (int)0, (int)this.pc2.getSubClassesArray().length);
        PersistentNakedClass[] pcSubclasses = this.pc.getSubClassesArray();
        PersistentNakedClassTest.assertEquals((String)"subclasses size", (int)1, (int)pcSubclasses.length);
        PersistentNakedClassTest.assertEquals((String)"subclasses 0", (Object)this.pc3, (Object)pcSubclasses[0]);
    }
}

